/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.extension.versioncheck.internal;

import java.util.Timer;
import java.util.TimerTask;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.extension.ExtensionId;
import org.xwiki.extension.ResolveException;
import org.xwiki.extension.repository.CoreExtensionRepository;
import org.xwiki.extension.repository.ExtensionRepositoryManager;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.versioncheck.ExtensionVersionCheckConfiguration;
import org.xwiki.extension.versioncheck.NewExtensionVersionAvailableEvent;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

@Singleton
@Component(roles={EnvironmentVersionCheckTimer.class})
public class EnvironmentVersionCheckTimer
implements Initializable {
    @Inject
    private Logger logger;
    @Inject
    private CoreExtensionRepository coreExtensionRepository;
    @Inject
    private ExtensionRepositoryManager extensionRepositoryManager;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private ExtensionVersionCheckConfiguration extensionVersionCheckConfiguration;

    public void initialize() throws InitializationException {
        Timer timer = new Timer();
        EnvironmentVersionCheckTask versionCheckTask = new EnvironmentVersionCheckTask();
        timer.schedule((TimerTask)versionCheckTask, 1000L * this.extensionVersionCheckConfiguration.environmentCheckInterval());
    }

    private class EnvironmentVersionCheckTask
    extends TimerTask {
        private Version latestVersion;
        private ExtensionId environmentExtensionId;

        EnvironmentVersionCheckTask() {
            this.environmentExtensionId = EnvironmentVersionCheckTimer.this.coreExtensionRepository.getEnvironmentExtension().getId();
            this.latestVersion = this.environmentExtensionId.getVersion();
        }

        private void performCheck() {
            boolean newVersionAvailable = false;
            try {
                for (Version version : EnvironmentVersionCheckTimer.this.extensionRepositoryManager.resolveVersions(this.environmentExtensionId.getId(), 0, -1)) {
                    if (!this.isCompatibleVersion(this.latestVersion, version)) continue;
                    newVersionAvailable = true;
                    this.latestVersion = version;
                }
            }
            catch (ResolveException e) {
                EnvironmentVersionCheckTimer.this.logger.warn("Failed to check if a new environment version is available: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
            if (newVersionAvailable) {
                EnvironmentVersionCheckTimer.this.observationManager.notify((Event)new NewExtensionVersionAvailableEvent(), (Object)this.environmentExtensionId, (Object)this.latestVersion);
            }
        }

        private boolean isCompatibleVersion(Version latestKnownVersion, Version proposedVersion) {
            if (proposedVersion.compareTo((Object)latestKnownVersion) <= 0) {
                return false;
            }
            Pattern versionPattern = EnvironmentVersionCheckTimer.this.extensionVersionCheckConfiguration.allowedEnvironmentVersions();
            if (versionPattern != null && !versionPattern.matcher(proposedVersion.getValue()).matches()) {
                return false;
            }
            return proposedVersion.getType().compareTo((Enum)latestKnownVersion.getType()) >= 0;
        }

        @Override
        public void run() {
            if (EnvironmentVersionCheckTimer.this.extensionVersionCheckConfiguration.isEnvironmentCheckEnabled()) {
                this.performCheck();
            }
        }
    }
}

