/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.groovy.internal;

import java.util.Arrays;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.classgen.BytecodeSequence;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.SecureASTCustomizer;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.groovy.GroovyCompilationCustomizer;

@Component
@Named(value="secure")
@Singleton
public class SecureGroovyCompilationCustomizer
implements GroovyCompilationCustomizer {
    @Inject
    private DocumentAccessBridge dab;

    public CompilationCustomizer createCustomizer() {
        SecureASTCustomizer customizer = null;
        if (!this.dab.hasProgrammingRights()) {
            SecureASTCustomizer secureCustomizer = new SecureASTCustomizer();
            secureCustomizer.setStarImportsWhitelist(Collections.emptyList());
            secureCustomizer.setStaticStarImportsWhitelist(Collections.emptyList());
            secureCustomizer.setImportsWhitelist(Collections.emptyList());
            secureCustomizer.setStaticStarImportsWhitelist(Collections.emptyList());
            secureCustomizer.setMethodDefinitionAllowed(false);
            secureCustomizer.setReceiversClassesWhiteList(Collections.emptyList());
            secureCustomizer.setReceiversWhiteList(Collections.emptyList());
            secureCustomizer.setTokensWhitelist(Collections.emptyList());
            secureCustomizer.setPackageAllowed(false);
            secureCustomizer.setExpressionsBlacklist(Arrays.asList(BytecodeExpression.class));
            secureCustomizer.setStatementsBlacklist(Arrays.asList(BytecodeSequence.class, SynchronizedStatement.class));
            customizer = secureCustomizer;
        }
        return customizer;
    }
}

