/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconManager;
import org.xwiki.icon.IconRenderer;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetManager;

@Component
@Singleton
public class DefaultIconManager
implements IconManager {
    @Inject
    private IconSetManager iconSetManager;
    @Inject
    private IconRenderer iconRenderer;

    public String render(String iconName) throws IconException {
        return this.iconRenderer.render(iconName, this.getIconSet(iconName));
    }

    public String render(String iconName, String iconSetName) throws IconException {
        return this.render(iconName, iconSetName, true);
    }

    public String render(String iconName, String iconSetName, boolean fallback) throws IconException {
        IconSet iconSet = this.getIconSet(iconName, iconSetName, fallback);
        if (iconSet == null) {
            return "";
        }
        return this.iconRenderer.render(iconName, iconSet);
    }

    public String renderHTML(String iconName) throws IconException {
        return this.iconRenderer.renderHTML(iconName, this.getIconSet(iconName));
    }

    public String renderHTML(String iconName, String iconSetName) throws IconException {
        return this.renderHTML(iconName, iconSetName, true);
    }

    public String renderHTML(String iconName, String iconSetName, boolean fallback) throws IconException {
        IconSet iconSet = this.getIconSet(iconName, iconSetName, fallback);
        if (iconSet == null) {
            return "";
        }
        return this.iconRenderer.renderHTML(iconName, iconSet);
    }

    public Map<String, Object> getMetaData(String iconName) throws IconException {
        return this.getMetaData(iconName, this.getIconSet(iconName));
    }

    public Map<String, Object> getMetaData(String iconName, String iconSetName) throws IconException {
        return this.getMetaData(iconName, iconSetName, true);
    }

    public Map<String, Object> getMetaData(String iconName, String iconSetName, boolean fallback) throws IconException {
        return this.getMetaData(iconName, this.getIconSet(iconName, iconSetName, fallback));
    }

    private Map<String, Object> getMetaData(String iconName, IconSet iconSet) throws IconException {
        HashMap<String, Object> metaData = new HashMap<String, Object>();
        if (iconSet != null) {
            metaData.put("iconSetName", iconSet.getName());
            metaData.put("iconSetType", iconSet.getType().name());
            metaData.put("url", this.iconRenderer.render(iconName, iconSet, iconSet.getIconUrl()));
            metaData.put("cssClass", this.iconRenderer.render(iconName, iconSet, iconSet.getIconCssClass()));
        }
        return metaData;
    }

    public List<String> getIconNames() throws IconException {
        return this.iconSetManager.getCurrentIconSet().getIconNames();
    }

    public List<String> getIconNames(String iconSetName) throws IconException {
        return this.iconSetManager.getIconSet(iconSetName).getIconNames();
    }

    private IconSet getIconSet(String iconName) throws IconException {
        return this.getIconSet(iconName, this.iconSetManager.getCurrentIconSet(), true);
    }

    private IconSet getIconSet(String iconName, String iconSetName, boolean fallback) throws IconException {
        return this.getIconSet(iconName, this.iconSetManager.getIconSet(iconSetName), fallback);
    }

    private IconSet getIconSet(String iconName, IconSet iconSet, boolean fallback) throws IconException {
        if (iconSet == null || iconSet.getIcon(iconName) == null) {
            if (fallback) {
                return this.iconSetManager.getDefaultIconSet();
            }
            return null;
        }
        return iconSet;
    }
}

