/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.IconException;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.XWikiVelocityException;

@Component(roles={VelocityRenderer.class})
@Singleton
public class VelocityRenderer {
    @Inject
    private VelocityManager velocityManager;

    public String render(String code) throws IconException {
        String namespace = "IconVelocityRenderer_" + Thread.currentThread().getId();
        StringWriter output = new StringWriter();
        VelocityEngine engine = null;
        try {
            engine = this.velocityManager.getVelocityEngine();
            engine.startedUsingMacroNamespace(namespace);
            VelocityContext context = new VelocityContext((Context)this.velocityManager.getVelocityContext());
            if (engine.evaluate((Context)context, (Writer)output, "DefaultIconRenderer", code)) {
                String string = output.toString();
                return string;
            }
            try {
                throw new IconException("Failed to render the icon. See the Velocity runtime log.", null);
            }
            catch (XWikiVelocityException e) {
                throw new IconException("Failed to render the icon.", (Throwable)e);
            }
        }
        finally {
            if (engine != null) {
                engine.stoppedUsingMacroNamespace(namespace);
            }
        }
    }
}

