/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal.context;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.internal.concurrent.AbstractContextStore;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetManager;
import org.xwiki.icon.internal.context.IconSetContext;

@Component
@Singleton
@Named(value="icon")
public class IconContextStore
extends AbstractContextStore {
    public static final String PROP_ICON_THEME = "icon.theme";
    @Inject
    private IconSetManager iconSetManager;
    @Inject
    private IconSetContext iconSetContext;
    @Inject
    private Logger logger;

    public IconContextStore() {
        super(new String[]{PROP_ICON_THEME});
    }

    public void save(Map<String, Serializable> contextStore, Collection<String> entries) {
        if (entries.contains(PROP_ICON_THEME)) {
            try {
                IconSet currentIconSet = this.iconSetManager.getCurrentIconSet();
                if (currentIconSet != null) {
                    contextStore.put(PROP_ICON_THEME, (Serializable)((Object)currentIconSet.getName()));
                }
            }
            catch (IconException e) {
                this.logger.error("Unexcepted error when getting current icon set", (Throwable)e);
            }
        }
    }

    public void restore(Map<String, Serializable> contextStore) {
        String iconSetName = (String)((Object)contextStore.get(PROP_ICON_THEME));
        if (iconSetName != null) {
            try {
                this.iconSetContext.setIconSet(this.iconSetManager.getIconSet(iconSetName));
            }
            catch (IconException e) {
                this.logger.error("Unexcepted error when getting icon set with name [{}]", (Throwable)e);
            }
        }
    }
}

