/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconManager;
import org.xwiki.icon.IconRenderer;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetManager;

@Component
@Singleton
public class DefaultIconManager
implements IconManager {
    @Inject
    private IconSetManager iconSetManager;
    @Inject
    private IconRenderer iconRenderer;

    public String render(String iconName) throws IconException {
        return this.iconRenderer.render(iconName, this.getIconSet(iconName));
    }

    public String render(String iconName, String iconSetName) throws IconException {
        return this.render(iconName, iconSetName, true);
    }

    public String render(String iconName, String iconSetName, boolean fallback) throws IconException {
        IconSet iconSet = this.getIconSet(iconName, iconSetName, fallback);
        if (iconSet == null) {
            return "";
        }
        return this.iconRenderer.render(iconName, iconSet);
    }

    public String renderHTML(String iconName) throws IconException {
        return this.iconRenderer.renderHTML(iconName, this.getIconSet(iconName));
    }

    public String renderHTML(String iconName, String iconSetName) throws IconException {
        return this.renderHTML(iconName, iconSetName, true);
    }

    public String renderHTML(String iconName, String iconSetName, boolean fallback) throws IconException {
        IconSet iconSet = this.getIconSet(iconName, iconSetName, fallback);
        if (iconSet == null) {
            return "";
        }
        return this.iconRenderer.renderHTML(iconName, iconSet);
    }

    public List<String> getIconNames() throws IconException {
        return this.iconSetManager.getCurrentIconSet().getIconNames();
    }

    public List<String> getIconNames(String iconSetName) throws IconException {
        return this.iconSetManager.getIconSet(iconSetName).getIconNames();
    }

    private IconSet getIconSet(String iconName) throws IconException {
        IconSet currentIconSet = this.iconSetManager.getCurrentIconSet();
        if (currentIconSet != null && currentIconSet.getIcon(iconName) != null) {
            return currentIconSet;
        }
        return this.iconSetManager.getDefaultIconSet();
    }

    private IconSet getIconSet(String iconName, String iconSetName, boolean fallback) throws IconException {
        IconSet iconSet = this.iconSetManager.getIconSet(iconSetName);
        if ((iconSet == null || iconSet.getIcon(iconName) == null) && fallback) {
            return this.iconSetManager.getDefaultIconSet();
        }
        return iconSet;
    }
}

