/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.IconSetCache;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;

@Component
@Named(value="iconTheme")
@Singleton
public class IconThemeListener
implements EventListener {
    private static final LocalDocumentReference ICON_THEME_CLASS = new LocalDocumentReference("IconThemesCode", "IconThemeClass");
    @Inject
    private IconSetCache iconSetCache;

    public String getName() {
        return "Icon Theme listener.";
    }

    public List<Event> getEvents() {
        return Arrays.asList(new DocumentUpdatedEvent(), new DocumentDeletedEvent());
    }

    public void onEvent(Event event, Object source, Object data) {
        XWikiDocument document = (XWikiDocument)source;
        List iconThemeObjects = document.getXObjects((EntityReference)ICON_THEME_CLASS);
        if (iconThemeObjects != null && !iconThemeObjects.isEmpty()) {
            this.iconSetCache.clear(document.getDocumentReference());
            BaseObject iconThemeObj = (BaseObject)iconThemeObjects.get(0);
            String iconThemeName = iconThemeObj.getStringValue("name");
            String currentWiki = document.getDocumentReference().getWikiReference().getName();
            this.iconSetCache.clear(iconThemeName, currentWiki);
        }
    }
}

