/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.icon.internal;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.bridge.DocumentModelBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.icon.Icon;
import org.xwiki.icon.IconException;
import org.xwiki.icon.IconSet;
import org.xwiki.icon.IconSetLoader;
import org.xwiki.icon.IconType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultIconSetLoader
implements IconSetLoader {
    private static final String CSS_PROPERTY_NAME = "xwiki.iconset.css";
    private static final String SSX_PROPERTY_NAME = "xwiki.iconset.ssx";
    private static final String JSX_PROPERTY_NAME = "xwiki.iconset.jsx";
    private static final String RENDER_WIKI_PROPERTY_NAME = "xwiki.iconset.render.wiki";
    private static final String RENDER_HTML_PROPERTY_NAME = "xwiki.iconset.render.html";
    private static final String ICON_TYPE_PROPERTY_NAME = "xwiki.iconset.type";
    private static final String ERROR_MSG = "Failed to load the IconSet [%s].";
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public IconSet loadIconSet(DocumentReference iconSetReference) throws IconException {
        try {
            DocumentModelBridge doc = this.documentAccessBridge.getDocument(iconSetReference);
            String content = doc.getContent();
            DocumentReference iconClassRef = new DocumentReference(this.wikiDescriptorManager.getCurrentWikiId(), "IconThemesCode", "IconThemeClass");
            String name = (String)this.documentAccessBridge.getProperty(iconSetReference, iconClassRef, "name");
            return this.loadIconSet(new StringReader(content), name);
        }
        catch (Exception e) {
            throw new IconException(String.format(ERROR_MSG, iconSetReference), (Throwable)e);
        }
    }

    public IconSet loadIconSet(Reader input, String name) throws IconException {
        try {
            IconSet iconSet = new IconSet(name);
            Properties properties = new Properties();
            properties.load(input);
            for (String key : properties.stringPropertyNames()) {
                String value = properties.getProperty(key);
                if (key.equals(CSS_PROPERTY_NAME)) {
                    iconSet.setCss(value);
                    continue;
                }
                if (key.equals(SSX_PROPERTY_NAME)) {
                    iconSet.setSsx(value);
                    continue;
                }
                if (key.equals(JSX_PROPERTY_NAME)) {
                    iconSet.setJsx(value);
                    continue;
                }
                if (key.equals(RENDER_WIKI_PROPERTY_NAME)) {
                    iconSet.setRenderWiki(value);
                    continue;
                }
                if (key.equals(RENDER_HTML_PROPERTY_NAME)) {
                    iconSet.setRenderHTML(value);
                    continue;
                }
                if (key.equals(ICON_TYPE_PROPERTY_NAME)) {
                    iconSet.setType(IconType.valueOf((String)value.toUpperCase()));
                    continue;
                }
                Icon icon = new Icon();
                icon.setValue(properties.getProperty(key));
                iconSet.addIcon(key, icon);
            }
            return iconSet;
        }
        catch (IOException e) {
            throw new IconException(String.format(ERROR_MSG, name), (Throwable)e);
        }
    }
}

