/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.internal.plugin.image;

import com.xpn.xwiki.internal.plugin.image.DefaultImageProcessor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.inject.Named;
import javax.inject.Singleton;
import net.coobird.thumbnailator.Thumbnails;
import org.xwiki.component.annotation.Component;

@Component
@Singleton
@Named(value="thumbnailator")
public class ThumbnailatorImageProcessor
extends DefaultImageProcessor {
    @Override
    public void writeImage(RenderedImage image, String mimeType, float quality, OutputStream out) throws IOException {
        if (image instanceof BufferedImage) {
            Thumbnails.of((BufferedImage[])new BufferedImage[]{(BufferedImage)image}).scale(1.0).outputFormat(this.getFormatNameForMimeType(mimeType)).outputQuality(quality).toOutputStream(out);
        } else {
            super.writeImage(image, mimeType, quality, out);
        }
    }

    @Override
    public RenderedImage scaleImage(Image image, int width, int height) {
        if (image instanceof BufferedImage) {
            try {
                return Thumbnails.of((BufferedImage[])new BufferedImage[]{(BufferedImage)image}).size(width, height).imageType(this.getBestImageTypeFor(image)).asBufferedImage();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.scaleImage(image, width, height);
    }

    private String getFormatNameForMimeType(String mimeType) {
        Iterator<ImageReader> imageReaders = ImageIO.getImageReadersByMIMEType(mimeType);
        if (imageReaders.hasNext()) {
            try {
                return imageReaders.next().getFormatName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return mimeType;
    }
}

