/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.index.test.po;

import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.xwiki.test.ui.po.LiveTableElement;
import org.xwiki.test.ui.po.ViewPage;

/**
 * Represents the actions possible on the AllDocs Page.
 * 
 * @version $Id: 50538108cf47c729e4c2c891d4895a34c490b9e9 $
 * @since 3.2M3
 */
public class AllDocsPage extends ViewPage
{
    @FindBy(xpath = "//li[@id='xwikiindex']/a")
    private WebElement indexTab;

    @FindBy(xpath = "//li[@id='xwikiattachments']/a")
    private WebElement attachmentsTab;

    public static AllDocsPage gotoPage()
    {
        getUtil().gotoPage("Main", "AllDocs");
        return new AllDocsPage();
    }

    public String getURL()
    {
        return getUtil().getURL("Main", "AllDocs");
    }

    public LiveTableElement clickIndexTab()
    {
        this.indexTab.click();

        LiveTableElement lt = new LiveTableElement("alldocs");
        lt.waitUntilReady();

        return lt;
    }

    public LiveTableElement clickAttachmentsTab()
    {
        this.attachmentsTab.click();

        LiveTableElement lt = new LiveTableElement("allattachments");
        lt.waitUntilReady();

        return lt;
    }
}
