/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages.query;

import com.xpn.xwiki.internal.store.hibernate.HibernateStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.hibernate.dialect.Dialect;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.tree.internal.nestedpages.query.AbstractNestedPageFilter;

@Component
@Named(value="hiddenPage/nestedPages")
@Singleton
public class HiddenPageFilter
extends AbstractNestedPageFilter {
    @Inject
    private HibernateStore hibernateStore;

    @Override
    protected String filterNestedPagesStatement(String statement) {
        String constraint = statement.indexOf("XWS_REFERENCE") < 0 ? "hidden <> true " : this.getHiddenConstraint("XWS_HIDDEN");
        return this.insertWhereConstraint(statement, constraint);
    }

    @Override
    protected String filterTerminalPagesStatement(String statement) {
        return statement + " and " + this.getHiddenConstraint("doc.XWD_HIDDEN");
    }

    private String getHiddenConstraint(String field) {
        return String.format("%s <> %s ", field, this.toBooleanValueString(true));
    }

    private String toBooleanValueString(boolean value) {
        Dialect dialect = this.hibernateStore.getDialect();
        return dialect.toBooleanValueString(value);
    }
}

