/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.parentchild;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.parentchild.DocumentQueryHelper;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;

@Component
@Named(value="wiki/parentChild")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class WikiTreeNode
extends org.xwiki.index.tree.internal.nestedpages.WikiTreeNode {
    @Inject
    @Named(value="count")
    private QueryFilter countQueryFilter;
    @Inject
    private DocumentQueryHelper documentQueryHelper;

    @Override
    protected List<? extends EntityReference> getChildren(WikiReference wikiReference, int offset, int limit) throws QueryException {
        return this.documentQueryHelper.resolve(this.getChildrenQuery(wikiReference), offset, limit, (EntityReference)wikiReference);
    }

    private Query getChildrenQuery(WikiReference parentReference) throws QueryException {
        Query query = this.documentQueryHelper.getQuery(Arrays.asList("(doc.parent = '' or doc.parent is null)", "doc.translation = 0"), Collections.emptyMap(), this.getProperties());
        query.setWiki(parentReference.getName());
        return query;
    }

    @Override
    protected int getChildCount(WikiReference wikiReference) throws QueryException {
        Query query = this.getChildrenQuery(wikiReference);
        query.addFilter(this.countQueryFilter);
        return ((Long)query.execute().get(0)).intValue();
    }
}

