/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.index.tree.internal.nestedpages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.index.tree.internal.AbstractEntityTreeNode;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="farm")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class FarmTreeNode
extends AbstractEntityTreeNode {
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public List<String> getChildren(String nodeId, int offset, int limit) {
        ArrayList<String> wikiIds = new ArrayList<String>(this.getWikiIds());
        ArrayList<String> children = new ArrayList<String>();
        for (String wikiId : this.subList(wikiIds, offset, limit)) {
            children.add("wiki:" + wikiId);
        }
        return children;
    }

    public int getChildCount(String nodeId) {
        return this.getWikiIds().size();
    }

    private Collection<String> getWikiIds() {
        try {
            LinkedHashSet<String> wikiIds = new LinkedHashSet<String>(this.wikiDescriptorManager.getAllIds());
            wikiIds.removeAll(this.getExcludedWikis());
            return wikiIds;
        }
        catch (WikiManagerException e) {
            this.logger.warn("Failed to retrieve the list of wikis. Root cause [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Collections.emptyList();
        }
    }
}

