/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.ircbot.internal;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.collections.Buffer;
import org.pircbotx.PircBotX;
import org.pircbotx.hooks.ListenerAdapter;
import org.pircbotx.hooks.events.MessageEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.ircbot.IRCBotListener;
import org.xwiki.ircbot.internal.BrokenLinkEventListener;
import org.xwiki.observation.EventListener;
import org.xwiki.rendering.transformation.linkchecker.LinkState;

@Component
@Named(value="brokenlink")
@Singleton
public class BrokenLinksBotListener<T extends PircBotX>
extends ListenerAdapter<T>
implements IRCBotListener<T> {
    private static final String COMMAND = "!bl";
    @Inject
    @Named(value="ircbrokenlink")
    private EventListener brokenLinkEventListener;

    @Override
    public String getName() {
        return "Broken Links";
    }

    @Override
    public String getDescription() {
        return String.format("%s: lists the latest broken links that have been found in the wiki", COMMAND);
    }

    public void onMessage(MessageEvent<T> event) throws Exception {
        if (event.getMessage().startsWith(COMMAND)) {
            Buffer latestBrokenLinks = ((BrokenLinkEventListener)this.brokenLinkEventListener).getLastBrokenLinks();
            if (latestBrokenLinks.size() > 0) {
                event.respond("Latest broken links:");
                for (Map linkData : latestBrokenLinks) {
                    String linkURL = (String)linkData.get("url");
                    String linkSource = (String)linkData.get("source");
                    LinkState linkState = (LinkState)linkData.get("state");
                    int responseCode = linkState.getResponseCode();
                    String message = String.format("%s on page %s (code = %s)", linkURL, linkSource, responseCode);
                    event.respond(message);
                }
            } else {
                event.respond("No broken links found so far or the Link Checker transformation is not active...");
            }
        }
    }
}

