/*
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.xwiki.lesscss.internal.colortheme;

import java.util.HashMap;

/**
 * Map containing color theme variables and their values.
 *
 * @since 7.0RC1
 * @version $Id: 28af8bd742c5313e1a7766d3fe4c0d83123e9b89 $
 */
public class ColorTheme extends HashMap<String, String>
{
    /**
     * Construct a new color theme.
     */
    public ColorTheme()
    {
        super();
    }

    /**
     * Construct a copy of a color theme.
     * @param colorTheme the color theme to copy
     */
    public ColorTheme(ColorTheme colorTheme)
    {
        super(colorTheme);
    }
}
