/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.cache;

import com.xpn.xwiki.XWikiContext;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.internal.LESSContext;
import org.xwiki.lesscss.internal.cache.CachedCompilerInterface;
import org.xwiki.lesscss.internal.cache.LESSCache;
import org.xwiki.lesscss.internal.colortheme.ColorThemeReference;
import org.xwiki.lesscss.internal.colortheme.ColorThemeReferenceFactory;
import org.xwiki.lesscss.internal.colortheme.CurrentColorThemeGetter;
import org.xwiki.lesscss.internal.compiler.DefaultLESSCompiler;
import org.xwiki.lesscss.internal.skin.SkinReference;
import org.xwiki.lesscss.internal.skin.SkinReferenceFactory;
import org.xwiki.lesscss.resources.LESSResourceReference;

public abstract class AbstractCachedCompiler<T> {
    protected LESSCache<T> cache;
    protected CachedCompilerInterface<T> compiler;
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    protected CurrentColorThemeGetter currentColorThemeGetter;
    @Inject
    protected SkinReferenceFactory skinReferenceFactory;
    @Inject
    protected ColorThemeReferenceFactory colorThemeReferenceFactory;
    @Inject
    protected LESSContext lessContext;
    @Inject
    protected Logger logger;

    public T getResult(LESSResourceReference lessResourceReference, boolean includeSkinStyle, boolean useVelocity, boolean force) throws LESSCompilerException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        String skin = context.getWiki().getSkin(context);
        return this.getResult(lessResourceReference, includeSkinStyle, useVelocity, skin, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResult(LESSResourceReference lessResourceReference, boolean includeSkinStyle, boolean useVelocity, String skin, boolean force) throws LESSCompilerException {
        Object mutex;
        if (this.lessContext.isCacheDisabled()) {
            return this.compiler.compute(lessResourceReference, includeSkinStyle, useVelocity, true, skin);
        }
        Object result = null;
        SkinReference skinReference = this.skinReferenceFactory.createReference(skin);
        ColorThemeReference colorThemeReference = this.colorThemeReferenceFactory.createReference(this.currentColorThemeGetter.getCurrentColorTheme(true, "default"));
        Object object = mutex = this.cache.getMutex(lessResourceReference, skinReference, colorThemeReference);
        synchronized (object) {
            if (!force && (result = this.cache.get(lessResourceReference, skinReference, colorThemeReference)) != null) {
                if (this.lessContext.isHtmlExport() && useVelocity && this instanceof DefaultLESSCompiler) {
                    this.compiler.compute(lessResourceReference, includeSkinStyle, true, false, skin);
                }
                return (T)this.cloneResult(result);
            }
            try {
                result = this.compiler.compute(lessResourceReference, includeSkinStyle, useVelocity, true, skin);
            }
            catch (LESSCompilerException e) {
                this.logger.error("Error during the compilation of the resource [{}].", (Object)lessResourceReference, (Object)e);
                result = this.exceptionAsResult(e);
            }
            finally {
                this.cache.set(lessResourceReference, skinReference, colorThemeReference, result);
            }
        }
        return (T)this.cloneResult(result);
    }

    protected abstract T cloneResult(T var1);

    protected abstract T exceptionAsResult(LESSCompilerException var1);
}

