/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.compiler.less4j;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.DefaultLessCompiler;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.internal.compiler.less4j.CustomContentLESSSource;
import org.xwiki.skin.SkinManager;
import org.xwiki.template.TemplateManager;

@Component(roles={Less4jCompiler.class})
@Singleton
public class Less4jCompiler {
    @Inject
    private TemplateManager templateManager;
    @Inject
    private SkinManager skinManager;

    public String compile(String lessCode, String skin, boolean inlineSourceMap) throws Less4jException {
        DefaultLessCompiler lessCompiler = new DefaultLessCompiler();
        LessCompiler.Configuration options = new LessCompiler.Configuration();
        options.setCompressing(true);
        options.getSourceMapConfiguration().setInline(inlineSourceMap);
        options.getSourceMapConfiguration().setIncludeSourcesContent(true);
        CustomContentLESSSource lessSource = new CustomContentLESSSource(lessCode, this.templateManager, this.skinManager.getSkin(skin));
        LessCompiler.CompilationResult lessResult = lessCompiler.compile((LessSource)lessSource, options);
        return lessResult.getCss();
    }
}

