/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheManager;
import org.xwiki.lesscss.LESSCache;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

public abstract class AbstractCache<T>
implements LESSCache<T> {
    private static final String CACHE_KEY_SEPARATOR = "_";
    @Inject
    protected CacheManager cacheManager;
    protected Cache<T> cache;
    private Map<String, List<String>> cachedFilesKeysMapPerSkin = new HashMap<String, List<String>>();
    private Map<String, List<String>> cachedFilesKeysMapPerColorTheme = new HashMap<String, List<String>>();
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public T get(String fileName, String fileSystemSkin, String colorTheme) {
        return (T)this.cache.get(this.getCacheKey(fileName, fileSystemSkin, this.getColorThemeFullName(colorTheme)));
    }

    public void set(String fileName, String fileSystemSkin, String colorTheme, T content) {
        String colorThemeFullName = this.getColorThemeFullName(colorTheme);
        String cacheKey = this.getCacheKey(fileName, fileSystemSkin, colorThemeFullName);
        this.cache.set(cacheKey, content);
        this.registerCacheKey(this.cachedFilesKeysMapPerSkin, cacheKey, fileSystemSkin);
        this.registerCacheKey(this.cachedFilesKeysMapPerColorTheme, cacheKey, colorTheme);
    }

    private void registerCacheKey(Map<String, List<String>> cachedFilesKeysMap, String cacheKey, String name) {
        List<String> cachedFilesKeys = cachedFilesKeysMap.get(name);
        if (cachedFilesKeys == null) {
            cachedFilesKeys = new ArrayList<String>();
            cachedFilesKeysMap.put(name, cachedFilesKeys);
        }
        if (!cachedFilesKeys.contains(cacheKey)) {
            cachedFilesKeys.add(cacheKey);
        }
    }

    public void clear() {
        this.cache.removeAll();
        this.cachedFilesKeysMapPerSkin.clear();
        this.cachedFilesKeysMapPerColorTheme.clear();
    }

    private void clearFromCriteria(Map<String, List<String>> cachedFilesKeysMap, String criteria) {
        List<String> cachedFilesKeys = cachedFilesKeysMap.get(criteria);
        if (cachedFilesKeys == null) {
            return;
        }
        for (String cachedFileKey : cachedFilesKeys) {
            this.cache.remove(cachedFileKey);
        }
        cachedFilesKeysMap.remove(criteria);
    }

    public void clearFromFileSystemSkin(String fileSystemSkin) {
        this.clearFromCriteria(this.cachedFilesKeysMapPerSkin, fileSystemSkin);
    }

    public void clearFromColorTheme(String colorTheme) {
        this.clearFromCriteria(this.cachedFilesKeysMapPerColorTheme, colorTheme);
    }

    private String getColorThemeFullName(String colorTheme) {
        WikiReference currentWikiRef = new WikiReference(this.wikiDescriptorManager.getCurrentWikiId());
        DocumentReference colorThemeRef = this.documentReferenceResolver.resolve((Object)colorTheme, new Object[]{currentWikiRef});
        return (String)this.entityReferenceSerializer.serialize((EntityReference)colorThemeRef, new Object[0]);
    }

    private String getCacheKey(String fileName, String skin, String colorThemeFullName) {
        return skin.length() + skin + CACHE_KEY_SEPARATOR + colorThemeFullName.length() + colorThemeFullName + CACHE_KEY_SEPARATOR + fileName.length() + fileName;
    }
}

