/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal;

import com.xpn.xwiki.XWikiContext;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.lesscss.LESSCache;
import org.xwiki.lesscss.LESSCompilerException;
import org.xwiki.lesscss.internal.CurrentColorThemeGetter;

public abstract class AbstractCachedCompiler<T> {
    protected LESSCache<T> cache;
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    private CurrentColorThemeGetter currentColorThemeGetter;
    private Map<String, Object> mutexList = new HashMap<String, Object>();

    public T compileFromSkinFile(String fileName, boolean force) throws LESSCompilerException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        String skin = context.getWiki().getSkin(context);
        return this.compileFromSkinFile(fileName, skin, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T compileFromSkinFile(String fileName, String skin, boolean force) throws LESSCompilerException {
        Object result;
        String colorTheme = this.currentColorThemeGetter.getCurrentColorTheme("default");
        Object object = this.getMutex(colorTheme);
        synchronized (object) {
            if (!force && (result = this.cache.get(fileName, skin, colorTheme)) != null) {
                return result;
            }
            result = this.compile(fileName, skin, force);
            this.cache.set(fileName, skin, colorTheme, result);
        }
        return result;
    }

    protected abstract T compile(String var1, String var2, boolean var3) throws LESSCompilerException;

    private synchronized Object getMutex(String colorThemeFullName) {
        Object mutex = this.mutexList.get(colorThemeFullName);
        if (mutex == null) {
            mutex = new Object();
            this.mutexList.put(colorThemeFullName, mutex);
        }
        return mutex;
    }
}

