/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.web.XWikiRequest;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.internal.CurrentColorThemeGetter;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultCurrentColorThemeGetter
implements CurrentColorThemeGetter {
    private static final String COLOR_THEME_FIELD = "colorTheme";
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    @Override
    public String getCurrentColorTheme(String fallbackValue) {
        String wikiId = this.wikiDescriptorManager.getCurrentWikiId();
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = context.getWiki();
        XWikiRequest request = context.getRequest();
        String colorTheme = request.getParameter(COLOR_THEME_FIELD);
        if (StringUtils.isEmpty((CharSequence)colorTheme)) {
            colorTheme = xwiki.getUserPreference(COLOR_THEME_FIELD, context);
        }
        DocumentReference colorThemeReference = this.documentReferenceResolver.resolve((Object)colorTheme, new Object[]{new WikiReference(wikiId)});
        colorTheme = (String)this.entityReferenceSerializer.serialize((EntityReference)colorThemeReference, new Object[0]);
        if (!xwiki.exists(colorThemeReference, context)) {
            colorTheme = fallbackValue;
        }
        return colorTheme;
    }
}

