/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.lesscss.ColorTheme;
import org.xwiki.lesscss.ColorThemeCache;
import org.xwiki.lesscss.LESSColorThemeConverter;
import org.xwiki.lesscss.LESSCompilerException;
import org.xwiki.lesscss.LESSSkinFileCompiler;
import org.xwiki.lesscss.internal.AbstractCachedCompiler;

@Component
@Singleton
public class DefaultLESSColorThemeConverter
extends AbstractCachedCompiler<ColorTheme>
implements LESSColorThemeConverter,
Initializable {
    @Inject
    private LESSSkinFileCompiler lessSkinFileCompiler;
    @Inject
    private ColorThemeCache cache;
    private final Pattern pattern = Pattern.compile("\\.colortheme-(\\w+)[\\s$]*\\{(\\w+):(#*\\w+)\\}");

    public void initialize() throws InitializationException {
        ((AbstractCachedCompiler)this).cache = this.cache;
    }

    public ColorTheme getColorThemeFromSkinFile(String fileName, boolean force) throws LESSCompilerException {
        return (ColorTheme)this.compileFromSkinFile(fileName, force);
    }

    public ColorTheme getColorThemeFromSkinFile(String fileName, String skin, boolean force) throws LESSCompilerException {
        return (ColorTheme)this.compileFromSkinFile(fileName, skin, force);
    }

    public ColorTheme getColorThemeFromCSS(String css) {
        ColorTheme results = new ColorTheme();
        String cssWithoutComments = css.replaceAll("/\\*[\\u0000-\\uffff]*?\\*/", "");
        Matcher m = this.pattern.matcher(cssWithoutComments);
        while (m.find()) {
            String variable = m.group(1);
            String value = m.group(3);
            results.put((Object)variable, (Object)value);
        }
        return results;
    }

    @Override
    protected ColorTheme compile(String fileName, String skin, boolean force) throws LESSCompilerException {
        return this.getColorThemeFromCSS(this.lessSkinFileCompiler.compileSkinFile(fileName, skin, false));
    }
}

