/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.lesscss.LESSCompiler;
import org.xwiki.lesscss.LESSCompilerException;
import org.xwiki.lesscss.LESSSkinFileCache;
import org.xwiki.lesscss.LESSSkinFileCompiler;
import org.xwiki.lesscss.internal.AbstractCachedCompiler;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultLESSSkinFileCompiler
extends AbstractCachedCompiler<String>
implements LESSSkinFileCompiler,
Initializable {
    private static final String SKIN_CONTEXT_KEY = "skin";
    @Inject
    private LESSCompiler lessCompiler;
    @Inject
    private LESSSkinFileCache cache;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public void initialize() throws InitializationException {
        ((AbstractCachedCompiler)this).cache = this.cache;
    }

    @Override
    protected String compile(String fileName, String skin, boolean force) throws LESSCompilerException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        String currentSkin = xwiki.getSkin(xcontext);
        try {
            String path = "/skins/" + this.getSkinDirectory(skin) + "/less";
            String realPath = xwiki.getEngineContext().getRealPath(path);
            File lessDirectory = new File(realPath);
            if (!lessDirectory.exists() || !lessDirectory.isDirectory()) {
                throw new LESSCompilerException(String.format("The path [%s] is not a directory or does not exists.", path));
            }
            Path lessFilesPath = Paths.get(xwiki.getEngineContext().getRealPath(path), new String[0]);
            Path[] includePaths = new Path[]{lessFilesPath};
            String fullFileName = path + "/" + fileName;
            File lessFile = new File(xwiki.getEngineContext().getRealPath(fullFileName));
            if (!lessFile.exists() || !lessFile.isFile()) {
                throw new LESSCompilerException(String.format("The path [%s] is not a file or does not exists.", fullFileName));
            }
            InputStream is = xwiki.getEngineContext().getResourceAsStream(fullFileName);
            StringWriter source = new StringWriter();
            IOUtils.copy((InputStream)is, (Writer)source);
            if (!currentSkin.equals(skin)) {
                xcontext.put((Object)SKIN_CONTEXT_KEY, (Object)skin);
            }
            String velocityParsedSource = xwiki.parseContent(source.toString(), xcontext);
            String string = this.lessCompiler.compile(velocityParsedSource, includePaths);
            return string;
        }
        catch (IOException | LESSCompilerException e) {
            throw new LESSCompilerException(String.format("Failed to compile the file [%s] with LESS.", fileName), (Exception)e);
        }
        finally {
            if (!currentSkin.equals(skin)) {
                xcontext.put((Object)SKIN_CONTEXT_KEY, (Object)currentSkin);
            }
        }
    }

    public String compileSkinFile(String fileName, boolean force) throws LESSCompilerException {
        return (String)this.compileFromSkinFile(fileName, force);
    }

    public String compileSkinFile(String fileName, String skin, boolean force) throws LESSCompilerException {
        return (String)this.compileFromSkinFile(fileName, skin, force);
    }

    private String getSkinDirectory(String skin) throws LESSCompilerException {
        return this.getSkinDirectory(skin, new ArrayList<String>());
    }

    private String getSkinDirectory(String skin, List<String> alreadyVisitedSkins) throws LESSCompilerException {
        if (alreadyVisitedSkins.contains(skin)) {
            throw new LESSCompilerException(String.format("Infinite loop of 'baseskin' dependencies [%s].", alreadyVisitedSkins.toString()), null);
        }
        alreadyVisitedSkins.add(skin);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        String currentWikiId = this.wikiDescriptorManager.getCurrentWikiId();
        DocumentReference skinDocRef = this.documentReferenceResolver.resolve((Object)skin, new Object[]{new WikiReference(currentWikiId)});
        if (skinDocRef != null && xwiki.exists(skinDocRef, xcontext)) {
            DocumentReference skinClass = new DocumentReference(skinDocRef.getWikiReference().getName(), "XWiki", "XWikiSkins");
            try {
                XWikiDocument skinDoc = xwiki.getDocument(skinDocRef, xcontext);
                BaseObject skinObj = skinDoc.getXObject(skinClass);
                if (skinObj != null) {
                    String baseSkin = skinObj.getStringValue("baseskin");
                    if (StringUtils.isBlank((String)baseSkin)) {
                        throw new LESSCompilerException(String.format("Failed to get the base skin of the skin [%s].", skin), null);
                    }
                    return this.getSkinDirectory(baseSkin, alreadyVisitedSkins);
                }
            }
            catch (XWikiException e) {
                throw new LESSCompilerException(String.format("Failed to get the document [%s].", skinDocRef), (Exception)((Object)e));
            }
        }
        return skin;
    }
}

