/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.cache;

import com.xpn.xwiki.XWikiContext;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.lesscss.cache.LESSCache;
import org.xwiki.lesscss.colortheme.ColorThemeReference;
import org.xwiki.lesscss.colortheme.ColorThemeReferenceFactory;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.internal.LESSContext;
import org.xwiki.lesscss.internal.cache.CacheKeyFactory;
import org.xwiki.lesscss.internal.cache.CachedCompilerInterface;
import org.xwiki.lesscss.internal.colortheme.CurrentColorThemeGetter;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.lesscss.skin.SkinReference;
import org.xwiki.lesscss.skin.SkinReferenceFactory;

public abstract class AbstractCachedCompiler<T> {
    protected LESSCache<T> cache;
    protected CachedCompilerInterface<T> compiler;
    @Inject
    protected Provider<XWikiContext> xcontextProvider;
    @Inject
    private CurrentColorThemeGetter currentColorThemeGetter;
    @Inject
    private SkinReferenceFactory skinReferenceFactory;
    @Inject
    private ColorThemeReferenceFactory colorThemeReferenceFactory;
    @Inject
    private CacheKeyFactory cacheKeyFactory;
    @Inject
    private LESSContext lessContext;
    private Map<String, String> mutexList = new HashMap<String, String>();

    public T getResult(LESSResourceReference lessResourceReference, boolean includeSkinStyle, boolean useVelocity, boolean force) throws LESSCompilerException {
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        String skin = context.getWiki().getSkin(context);
        return this.getResult(lessResourceReference, includeSkinStyle, useVelocity, skin, force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getResult(LESSResourceReference lessResourceReference, boolean includeSkinStyle, boolean useVelocity, String skin, boolean force) throws LESSCompilerException {
        String mutex;
        if (this.lessContext.isCacheDisabled()) {
            return this.compiler.compute(lessResourceReference, includeSkinStyle, useVelocity, skin);
        }
        Object result = null;
        SkinReference skinReference = this.skinReferenceFactory.createReference(skin);
        ColorThemeReference colorThemeReference = this.colorThemeReferenceFactory.createReference(this.currentColorThemeGetter.getCurrentColorTheme("default"));
        String string = mutex = this.getMutex(lessResourceReference, skinReference, colorThemeReference);
        synchronized (string) {
            if (!force && (result = this.cache.get(lessResourceReference, skinReference, colorThemeReference)) != null) {
                return (T)this.cloneResult(result);
            }
            try {
                result = this.compiler.compute(lessResourceReference, includeSkinStyle, useVelocity, skin);
            }
            finally {
                this.cache.set(lessResourceReference, skinReference, colorThemeReference, result);
            }
        }
        return (T)this.cloneResult(result);
    }

    protected abstract T cloneResult(T var1);

    private synchronized String getMutex(LESSResourceReference lessResourceReference, SkinReference skinReference, ColorThemeReference colorThemeReference) {
        String cacheKey = this.cacheKeyFactory.getCacheKey(lessResourceReference, skinReference, colorThemeReference);
        String mutex = this.mutexList.get(cacheKey);
        if (mutex == null) {
            mutex = cacheKey;
            this.mutexList.put(cacheKey, mutex);
        }
        return mutex;
    }
}

