/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.cache;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.colortheme.ColorThemeReference;
import org.xwiki.lesscss.colortheme.ColorThemeReferenceSerializer;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.lesscss.resources.LESSResourceReferenceSerializer;
import org.xwiki.lesscss.skin.SkinReference;
import org.xwiki.lesscss.skin.SkinReferenceSerializer;

@Component(roles={CacheKeyFactory.class})
@Singleton
public class CacheKeyFactory {
    private static final String CACHE_KEY_SEPARATOR = "_";
    @Inject
    private LESSResourceReferenceSerializer lessResourceReferenceSerializer;
    @Inject
    private SkinReferenceSerializer skinReferenceSerializer;
    @Inject
    private ColorThemeReferenceSerializer colorThemeReferenceSerializer;

    public String getCacheKey(LESSResourceReference lessResourceReference, SkinReference skinReference, ColorThemeReference colorThemeReference) {
        String lessResource = this.lessResourceReferenceSerializer.serialize(lessResourceReference);
        String skin = this.skinReferenceSerializer.serialize(skinReference);
        String colorTheme = this.colorThemeReferenceSerializer.serialize(colorThemeReference);
        return lessResource.length() + CACHE_KEY_SEPARATOR + lessResource + CACHE_KEY_SEPARATOR + skin.length() + CACHE_KEY_SEPARATOR + skin + CACHE_KEY_SEPARATOR + colorTheme.length() + CACHE_KEY_SEPARATOR + colorTheme;
    }
}

