/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.colortheme;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.colortheme.ColorThemeReference;
import org.xwiki.lesscss.colortheme.ColorThemeReferenceFactory;
import org.xwiki.lesscss.colortheme.DocumentColorThemeReference;
import org.xwiki.lesscss.colortheme.NamedColorThemeReference;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultColorThemeReferenceFactory
implements ColorThemeReferenceFactory {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public ColorThemeReference createReference(String colorThemeName) throws LESSCompilerException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        String currentWikiId = this.wikiDescriptorManager.getCurrentWikiId();
        DocumentReference colorThemeDocRef = this.documentReferenceResolver.resolve((Object)colorThemeName, new Object[]{new WikiReference(currentWikiId)});
        if (xwiki.exists(colorThemeDocRef, xcontext)) {
            try {
                XWikiDocument colorThemeDoc = xwiki.getDocument(colorThemeDocRef, xcontext);
                DocumentReference colorThemeClassRef = new DocumentReference(colorThemeDocRef.getWikiReference().getName(), "ColorThemes", "ColorThemeClass");
                if (colorThemeDoc.getXObjectSize(colorThemeClassRef) > 0) {
                    return new DocumentColorThemeReference(colorThemeDocRef);
                }
                DocumentReference flamingoThemeClassRef = new DocumentReference(colorThemeDocRef.getWikiReference().getName(), "FlamingoThemesCode", "ThemeClass");
                if (colorThemeDoc.getXObjectSize(flamingoThemeClassRef) > 0) {
                    return new DocumentColorThemeReference(colorThemeDocRef);
                }
            }
            catch (XWikiException e) {
                throw new LESSCompilerException(String.format("Unable to read document [%s]", colorThemeDocRef));
            }
        }
        return new NamedColorThemeReference(colorThemeName);
    }
}

