/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.colortheme;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.lesscss.colortheme.ColorThemeReference;
import org.xwiki.lesscss.colortheme.ColorThemeReferenceSerializer;

@Component
@Singleton
public class DefaultColorThemeReferenceSerializer
implements ColorThemeReferenceSerializer {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Logger logger;

    public String serialize(ColorThemeReference colorThemeReference) {
        try {
            ColorThemeReferenceSerializer serializer = (ColorThemeReferenceSerializer)this.componentManager.getInstance(ColorThemeReferenceSerializer.class, colorThemeReference.getClass().getName());
            return serializer.serialize(colorThemeReference);
        }
        catch (ComponentLookupException e) {
            this.logger.warn("The color theme type [{}] is not handled by the LESS Module.", (Object)colorThemeReference, (Object)e);
            return null;
        }
    }
}

