/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.compiler;

import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import javax.inject.Singleton;
import org.lesscss.LessCompiler;
import org.lesscss.LessException;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.lesscss.compiler.LESSCompiler;
import org.xwiki.lesscss.compiler.LESSCompilerException;

@Component
@Singleton
public class DefaultLESSCompiler
implements LESSCompiler,
Initializable {
    private static final String LESS_SOURCE_FILE = "/less-rhino-1.7.0.js";
    private static final String LESSC_SOURCE_FILE = "/lessc-rhino-1.7.0.js";
    private static final String ERROR_MESSAGE = "Error during the LESS processing.";
    private LessCompiler lessCompiler;

    public void initialize() throws InitializationException {
        this.lessCompiler = new LessCompiler();
        this.lessCompiler.setLessJs(this.getClass().getResource(LESS_SOURCE_FILE));
        this.lessCompiler.setLesscJs(this.getClass().getResource(LESSC_SOURCE_FILE));
        this.lessCompiler.setCompress(true);
        this.lessCompiler.init();
    }

    public String compile(String lessCode) throws LESSCompilerException {
        try {
            return this.lessCompiler.compile(lessCode);
        }
        catch (LessException e) {
            throw new LESSCompilerException(ERROR_MESSAGE, (Exception)((Object)e));
        }
    }

    public String compile(String lessCode, Path[] includePaths) throws LESSCompilerException {
        LessCompiler compiler = this.lessCompiler;
        if (includePaths.length > 0) {
            StringBuilder paths = new StringBuilder("--include-path=");
            for (int i = 0; i < includePaths.length; ++i) {
                paths.append(includePaths[i].toString()).append(File.pathSeparator);
            }
            compiler = new LessCompiler(Arrays.asList(paths.toString()));
            compiler.setLessJs(this.getClass().getResource(LESS_SOURCE_FILE));
            compiler.setLesscJs(this.getClass().getResource(LESSC_SOURCE_FILE));
            compiler.setCompress(true);
            compiler.init();
        }
        try {
            return compiler.compile(lessCode);
        }
        catch (LessException e) {
            throw new LESSCompilerException(ERROR_MESSAGE, (Exception)((Object)e));
        }
    }
}

