/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.resources;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.resources.LESSObjectPropertyResourceReference;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.lesscss.resources.LESSResourceReferenceSerializer;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Named(value="org.xwiki.lesscss.resources.LESSObjectPropertyResourceReference")
@Singleton
public class LESSObjectPropertyResourceReferenceSerializer
implements LESSResourceReferenceSerializer {
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Logger logger;

    public String serialize(LESSResourceReference lessResourceReference) {
        if (!(lessResourceReference instanceof LESSObjectPropertyResourceReference)) {
            this.logger.warn("Invalid LESS resource type [{}].", (Object)lessResourceReference.toString());
            return null;
        }
        LESSObjectPropertyResourceReference lessObjectPropertyResourceReference = (LESSObjectPropertyResourceReference)lessResourceReference;
        return String.format("LessEntity[%s]", this.entityReferenceSerializer.serialize((EntityReference)lessObjectPropertyResourceReference.getObjectPropertyReference(), new Object[0]));
    }
}

