/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.resources;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.lesscss.resources.LESSResourceReferenceSerializer;
import org.xwiki.lesscss.resources.LESSSkinFileResourceReference;

@Component
@Named(value="org.xwiki.lesscss.resources.LESSSkinFileResourceReference")
@Singleton
public class LESSSkinFileResourceReferenceSerializer
implements LESSResourceReferenceSerializer {
    @Inject
    private Logger logger;

    public String serialize(LESSResourceReference lessResourceReference) {
        if (!(lessResourceReference instanceof LESSSkinFileResourceReference)) {
            this.logger.warn("Invalid LESS resource type [{}].", (Object)lessResourceReference.toString());
            return null;
        }
        LESSSkinFileResourceReference lessSkinFileResourceReference = (LESSSkinFileResourceReference)lessResourceReference;
        return String.format("LessSkinFile[%s]", lessSkinFileResourceReference.getFileName());
    }
}

