/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.skin;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.skin.DocumentSkinReference;
import org.xwiki.lesscss.skin.SkinReference;
import org.xwiki.lesscss.skin.SkinReferenceSerializer;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Named(value="org.xwiki.lesscss.skin.DocumentSkinReference")
@Singleton
public class DocumentSkinReferenceSerializer
implements SkinReferenceSerializer {
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Logger logger;

    public String serialize(SkinReference skinReference) {
        if (!(skinReference instanceof DocumentSkinReference)) {
            this.logger.warn("Invalid LESS resource type [{}].", (Object)skinReference.toString());
            return null;
        }
        DocumentSkinReference docSkinRef = (DocumentSkinReference)skinReference;
        return String.format("SkinDocument[%s]", this.entityReferenceSerializer.serialize((EntityReference)docSkinRef.getSkinDocument(), new Object[0]));
    }
}

