/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.localization.LocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;

@Component
@Singleton
public class DefaultContextualLocalizationManager
implements ContextualLocalizationManager {
    @Inject
    private LocalizationManager localizationManager;
    @Inject
    private LocalizationContext localizationContext;
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainRenderer;

    @Override
    public Translation getTranslation(String key) {
        return this.localizationManager.getTranslation(key, this.localizationContext.getCurrentLocale());
    }

    @Override
    public String getTranslationPlain(String key, Object ... parameters) {
        Translation translation = this.getTranslation(key);
        if (translation == null) {
            return null;
        }
        Block block = translation.render(parameters);
        DefaultWikiPrinter wikiPrinter = new DefaultWikiPrinter();
        this.plainRenderer.render(block, (WikiPrinter)wikiPrinter);
        return wikiPrinter.toString();
    }
}

