/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.localization.Translation;
import org.xwiki.localization.internal.AbstractTranslationBundle;
import org.xwiki.localization.internal.LocalizedBundle;

public abstract class AbstractCachedTranslationBundle
extends AbstractTranslationBundle {
    protected Map<Locale, LocalizedBundle> bundleCache = new ConcurrentHashMap<Locale, LocalizedBundle>();

    protected AbstractCachedTranslationBundle() {
    }

    public AbstractCachedTranslationBundle(String id) {
        super(id);
    }

    public AbstractCachedTranslationBundle(String id, int priority) {
        super(id, priority);
    }

    private Locale getParentLocale(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (StringUtils.isEmpty((CharSequence)language)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)country)) {
            return Locale.ROOT;
        }
        if (StringUtils.isEmpty((CharSequence)variant)) {
            return new Locale(language);
        }
        return new Locale(language, country);
    }

    private LocalizedBundle getLocalizedBundle(Locale locale) {
        String localeString = locale.toString();
        LocalizedBundle bundle = this.bundleCache.get(localeString);
        if (bundle == null) {
            bundle = this.getSynchLocalizedBundle(locale);
        }
        return bundle;
    }

    private synchronized LocalizedBundle getSynchLocalizedBundle(Locale locale) {
        LocalizedBundle bundle = this.bundleCache.get(locale);
        if (bundle == null) {
            bundle = this.createBundle(locale);
            if (bundle == null) {
                bundle = LocalizedBundle.EMPTY;
            }
            this.bundleCache.put(locale, bundle);
        }
        return bundle;
    }

    @Override
    public Translation getTranslation(String key, Locale locale) {
        Translation translation;
        LocalizedBundle bundle = this.getLocalizedBundle(locale);
        if (bundle != null) {
            Locale parentLocale;
            translation = bundle.getTranslation(key);
            if (translation == null && (parentLocale = this.getParentLocale(locale)) != null) {
                translation = this.getTranslation(key, parentLocale);
            }
        } else {
            translation = null;
        }
        return translation;
    }

    protected abstract LocalizedBundle createBundle(Locale var1);
}

