/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import java.util.Collection;
import java.util.Locale;
import org.xwiki.localization.Translation;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.TranslationBundleContext;
import org.xwiki.localization.internal.LocalizedBundle;
import org.xwiki.localization.message.TranslationMessage;
import org.xwiki.rendering.block.Block;

public abstract class AbstractTranslation
implements Translation {
    private TranslationBundleContext context;
    private LocalizedBundle localeBundle;
    private String key;
    private TranslationMessage message;

    public AbstractTranslation(TranslationBundleContext context, LocalizedBundle localeBundle, String key, TranslationMessage message) {
        this.context = context;
        this.localeBundle = localeBundle;
        this.key = key;
        this.message = message;
    }

    @Override
    public TranslationBundle getBundle() {
        return this.localeBundle.getBundle();
    }

    @Override
    public Locale getLocale() {
        return this.localeBundle.getLocale();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getRawSource() {
        return this.message.getRawSource();
    }

    private Collection<TranslationBundle> getCurrentBundles() {
        return this.context != null ? this.context.getBundles() : null;
    }

    @Override
    public Block render(Locale locale, Object ... parameters) {
        return this.message.render(locale != null ? locale : this.getLocale(), this.getCurrentBundles(), parameters);
    }

    @Override
    public Block render(Object ... parameters) {
        return this.render(null, parameters);
    }

    public String toString() {
        return this.getKey() + ':' + this.message.toString();
    }
}

