/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import java.util.Locale;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.xwiki.localization.Translation;
import org.xwiki.localization.TranslationBundle;

public abstract class AbstractTranslationBundle
implements TranslationBundle {
    public static final TranslationBundle EMPTY = new AbstractTranslationBundle(null){

        @Override
        public Translation getTranslation(String key, Locale locale) {
            return null;
        }
    };
    @Inject
    protected Logger logger;
    private String id;
    private int priority = 1000;

    protected AbstractTranslationBundle() {
    }

    public AbstractTranslationBundle(String id) {
        this.id = id;
    }

    public AbstractTranslationBundle(String id, int priority) {
        this.id = id;
        this.priority = priority;
    }

    @Override
    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public int compareTo(TranslationBundle otherBundle) {
        if (this.getPriority() != otherBundle.getPriority()) {
            return this.getPriority() - otherBundle.getPriority();
        }
        return this.getClass().getSimpleName().compareTo(otherBundle.getClass().getSimpleName());
    }

    public String toString() {
        return this.getId();
    }
}

