/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.localization.Translation;
import org.xwiki.localization.internal.AbstractTranslationBundle;
import org.xwiki.localization.internal.LocalizedTranslationBundle;

public abstract class AbstractCachedTranslationBundle
extends AbstractTranslationBundle {
    protected Map<Locale, LocalizedTranslationBundle> bundleCache = new ConcurrentHashMap<Locale, LocalizedTranslationBundle>();

    protected AbstractCachedTranslationBundle() {
    }

    public AbstractCachedTranslationBundle(String id) {
        super(id);
    }

    public AbstractCachedTranslationBundle(String id, int priority) {
        super(id, priority);
    }

    private LocalizedTranslationBundle getLocalizedBundle(Locale locale) {
        LocalizedTranslationBundle bundle = this.bundleCache.get(locale);
        if (bundle == null) {
            bundle = this.getSynchLocalizedBundle(locale);
        }
        return bundle;
    }

    private synchronized LocalizedTranslationBundle getSynchLocalizedBundle(Locale locale) {
        LocalizedTranslationBundle bundle = this.bundleCache.get(locale);
        if (bundle == null) {
            bundle = this.createBundle(locale);
            if (bundle == null) {
                bundle = LocalizedTranslationBundle.EMPTY;
            }
            this.bundleCache.put(locale, bundle);
        }
        return bundle;
    }

    @Override
    public Translation getTranslation(String key, Locale locale) {
        Translation translation;
        LocalizedTranslationBundle bundle = this.getLocalizedBundle(locale);
        if (bundle != null) {
            Locale parentLocale;
            translation = bundle.getTranslation(key);
            if (translation == null && (parentLocale = LocaleUtils.getParentLocale(locale)) != null) {
                translation = this.getTranslation(key, parentLocale);
            }
        } else {
            translation = null;
        }
        return translation;
    }

    protected abstract LocalizedTranslationBundle createBundle(Locale var1);
}

