/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.wiki.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.StringProperty;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.descriptor.DefaultComponentDescriptor;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.manager.ComponentRepositoryException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.TranslationBundleContext;
import org.xwiki.localization.TranslationBundleDoesNotExistsException;
import org.xwiki.localization.TranslationBundleFactory;
import org.xwiki.localization.message.TranslationMessageParser;
import org.xwiki.localization.wiki.internal.DefaultDocumentTranslationBundle;
import org.xwiki.localization.wiki.internal.TranslationDocumentModel;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="document")
@Singleton
public class DocumentTranslationBundleFactory
implements TranslationBundleFactory,
Initializable,
Disposable {
    public static final String ID = "document";
    public static final String ID_PREFIX = "document:";
    private static final List<Event> EVENTS = Arrays.asList(new DocumentUpdatedEvent(), new DocumentDeletedEvent(), new DocumentCreatedEvent());
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    @Named(value="uid")
    private EntityReferenceSerializer<String> uidSerializer;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentResolver;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private ObservationManager observation;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    @Named(value="messagetool/1.0")
    private TranslationMessageParser translationParser;
    @Inject
    private ComponentManagerManager cmManager;
    @Inject
    private Logger logger;
    @Inject
    private QueryManager queryManager;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private TranslationBundleContext bundleContext;
    private Cache<TranslationBundle> bundlesCache;
    private EventListener listener = new EventListener(){

        public void onEvent(Event event, Object arg1, Object arg2) {
            DocumentTranslationBundleFactory.this.translationDocumentUpdated((XWikiDocument)arg1);
        }

        public String getName() {
            return "localization.bundle.document";
        }

        public List<Event> getEvents() {
            return EVENTS;
        }
    };

    public void initialize() throws InitializationException {
        HashSet<String> wikis;
        CacheConfiguration cacheConfiguration = new CacheConfiguration("localization.bundle.document");
        try {
            this.bundlesCache = this.cacheManager.createNewCache(cacheConfiguration);
        }
        catch (CacheException e) {
            this.logger.error("Failed to create cache [{}]", (Object)cacheConfiguration.getConfigurationId(), (Object)e);
        }
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        try {
            wikis = new HashSet<String>(xcontext.getWiki().getVirtualWikisDatabaseNames(xcontext));
        }
        catch (XWikiException e) {
            this.logger.error("Failed to list existing wikis", (Throwable)e);
            wikis = new HashSet();
        }
        if (!wikis.contains(xcontext.getMainXWiki())) {
            wikis.add(xcontext.getMainXWiki());
        }
        for (String wiki : wikis) {
            this.loadTranslations(wiki, xcontext);
        }
        this.observation.addListener(this.listener);
    }

    private void loadTranslations(String wiki, XWikiContext xcontext) {
        try {
            Query query = this.queryManager.createQuery(String.format("select distinct doc.space, doc.name from Document doc, doc.object(%s) as translation", "XWiki.TranslationDocumentClass"), "xwql");
            query.setWiki(wiki);
            List documents = query.execute();
            for (Object[] documentName : documents) {
                DocumentReference reference = new DocumentReference(wiki, (String)documentName[0], (String)documentName[1]);
                XWikiDocument document = xcontext.getWiki().getDocument(reference, xcontext);
                try {
                    this.registerTranslationBundle(document);
                }
                catch (Exception e) {
                    this.logger.error("Failed to register translation bundle from document [{}]", (Object)document.getDocumentReference(), (Object)e);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to load existing translations", (Throwable)e);
        }
    }

    public TranslationBundle getBundle(String bundleId) throws TranslationBundleDoesNotExistsException {
        String roleHint = ID_PREFIX + bundleId;
        if (((ComponentManager)this.componentManagerProvider.get()).hasComponent(TranslationBundle.class, roleHint)) {
            try {
                return (TranslationBundle)((ComponentManager)this.componentManagerProvider.get()).getInstance(TranslationBundle.class, roleHint);
            }
            catch (ComponentLookupException e) {
                this.logger.debug("Failed to lookup component [{}] with hint [{}].", new Object[]{TranslationBundle.class, bundleId, e});
            }
        }
        return this.getDocumentBundle(this.currentResolver.resolve((Object)bundleId, new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TranslationBundle getDocumentBundle(DocumentReference documentReference) throws TranslationBundleDoesNotExistsException {
        String uid = (String)this.uidSerializer.serialize((EntityReference)documentReference, new Object[0]);
        Object bundle = (TranslationBundle)this.bundlesCache.get(uid);
        if (bundle == null) {
            Cache<TranslationBundle> cache = this.bundlesCache;
            synchronized (cache) {
                bundle = (TranslationBundle)this.bundlesCache.get(uid);
                if (bundle == null) {
                    bundle = this.createDocumentBundle(documentReference);
                    this.bundlesCache.set(uid, bundle);
                }
            }
        }
        return bundle;
    }

    private DefaultDocumentTranslationBundle createDocumentBundle(DocumentReference documentReference) throws TranslationBundleDoesNotExistsException {
        XWikiDocument document;
        XWikiContext context = (XWikiContext)this.xcontextProvider.get();
        try {
            document = context.getWiki().getDocument(documentReference, context);
        }
        catch (XWikiException e) {
            throw new TranslationBundleDoesNotExistsException("Failed to get translation document", (Throwable)e);
        }
        if (document.isNew()) {
            throw new TranslationBundleDoesNotExistsException(String.format("Document [%s] does not exists", documentReference));
        }
        return this.createDocumentBundle(document);
    }

    private DefaultDocumentTranslationBundle createDocumentBundle(XWikiDocument document) throws TranslationBundleDoesNotExistsException {
        DefaultDocumentTranslationBundle documentBundle;
        BaseObject translationObject = document.getXObject(TranslationDocumentModel.TRANSLATIONCLASS_REFERENCE);
        if (translationObject == null) {
            throw new TranslationBundleDoesNotExistsException(String.format("[%s] is not a translation document", document));
        }
        try {
            documentBundle = new DefaultDocumentTranslationBundle(ID_PREFIX, document.getDocumentReference(), (ComponentManager)this.componentManagerProvider.get(), this.translationParser);
        }
        catch (ComponentLookupException e) {
            throw new TranslationBundleDoesNotExistsException("Failed to create document bundle", (Throwable)e);
        }
        return documentBundle;
    }

    private void translationDocumentUpdated(XWikiDocument document) {
        if (!document.getOriginalDocument().isNew()) {
            this.unregisterTranslationBundle(document.getOriginalDocument());
        }
        if (!document.isNew()) {
            try {
                this.registerTranslationBundle(document);
            }
            catch (Exception e) {
                this.logger.error("Failed to register translation bundle from document [{}]", (Object)document.getDocumentReference(), (Object)e);
            }
        }
    }

    private TranslationDocumentModel.Scope getScope(BaseObject obj) {
        StringProperty scopeProperty;
        if (obj != null && (scopeProperty = (StringProperty)obj.getField("scope")) != null) {
            String scopeString = scopeProperty.getValue();
            return (TranslationDocumentModel.Scope)EnumUtils.getEnum(TranslationDocumentModel.Scope.class, (String)scopeString.toUpperCase());
        }
        return null;
    }

    private void unregisterTranslationBundle(XWikiDocument document) {
        BaseObject obj = document.getXObject(TranslationDocumentModel.TRANSLATIONCLASS_REFERENCE);
        if (obj != null) {
            TranslationDocumentModel.Scope scope = this.getScope(obj);
            if (scope != null && scope != TranslationDocumentModel.Scope.ON_DEMAND) {
                ComponentDescriptor<TranslationBundle> descriptor = this.createComponentDescriptor(document.getDocumentReference());
                this.getComponentManager(document, scope, true).unregisterComponent(descriptor);
            }
            this.bundlesCache.remove((String)this.uidSerializer.serialize((EntityReference)document.getDocumentReference(), new Object[0]));
        }
    }

    void clear(String uid) {
        this.bundlesCache.remove(uid);
    }

    private void registerTranslationBundle(XWikiDocument document) throws TranslationBundleDoesNotExistsException, ComponentRepositoryException, AccessDeniedException {
        TranslationDocumentModel.Scope scope;
        BaseObject obj = document.getXObject(TranslationDocumentModel.TRANSLATIONCLASS_REFERENCE);
        if (obj != null && (scope = this.getScope(obj)) != null && scope != TranslationDocumentModel.Scope.ON_DEMAND) {
            this.checkRegistrationAuthorization(document, scope);
            DefaultDocumentTranslationBundle bundle = this.createDocumentBundle(document);
            ComponentDescriptor<TranslationBundle> descriptor = this.createComponentDescriptor(document.getDocumentReference());
            this.getComponentManager(document, scope, true).registerComponent(descriptor, (Object)bundle);
            this.bundleContext.addBundle((TranslationBundle)bundle);
        }
    }

    private void checkRegistrationAuthorization(XWikiDocument document, TranslationDocumentModel.Scope scope) throws AccessDeniedException {
        switch (scope) {
            case GLOBAL: {
                this.authorizationManager.checkAccess(Right.PROGRAM, document.getAuthorReference(), null);
                break;
            }
            case WIKI: {
                this.authorizationManager.checkAccess(Right.ADMIN, document.getAuthorReference(), (EntityReference)document.getDocumentReference().getWikiReference());
                break;
            }
        }
    }

    private ComponentDescriptor<TranslationBundle> createComponentDescriptor(DocumentReference documentReference) {
        DefaultComponentDescriptor descriptor = new DefaultComponentDescriptor();
        descriptor.setImplementation(DefaultDocumentTranslationBundle.class);
        descriptor.setInstantiationStrategy(ComponentInstantiationStrategy.SINGLETON);
        descriptor.setRoleHint(ID_PREFIX + (String)this.serializer.serialize((EntityReference)documentReference, new Object[0]));
        descriptor.setRoleType(TranslationBundle.class);
        return descriptor;
    }

    private ComponentManager getComponentManager(XWikiDocument document, TranslationDocumentModel.Scope scope, boolean create) {
        String hint;
        switch (scope) {
            case WIKI: {
                hint = "wiki:" + document.getDocumentReference().getWikiReference().getName();
                break;
            }
            case USER: {
                hint = "user:" + (String)this.serializer.serialize((EntityReference)document.getAuthorReference(), new Object[0]);
                break;
            }
            default: {
                hint = null;
            }
        }
        return this.cmManager.getComponentManager(hint, create);
    }

    public void dispose() throws ComponentLifecycleException {
        this.observation.removeListener(this.listener.getName());
    }
}

