/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.MailStatusResult;

public class CompositeMailListener
implements MailListener {
    private final MailListener mainListener;
    private final List<MailListener> listeners;

    public CompositeMailListener(MailListener mainListener, MailListener ... listeners) {
        this.mainListener = mainListener;
        this.listeners = new ArrayList<MailListener>(1 + listeners.length);
        this.listeners.add(mainListener);
        for (MailListener listener : listeners) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void onPrepareBegin(String batchId, Map<String, Object> parameters) {
        this.listeners.forEach(l -> l.onPrepareBegin(batchId, parameters));
    }

    @Override
    public void onPrepareMessageSuccess(ExtendedMimeMessage message, Map<String, Object> parameters) {
        this.listeners.forEach(l -> l.onPrepareMessageSuccess(message, parameters));
    }

    @Override
    public void onPrepareMessageError(ExtendedMimeMessage message, Exception e, Map<String, Object> parameters) {
        this.listeners.forEach(l -> l.onPrepareMessageError(message, e, parameters));
    }

    @Override
    public void onPrepareFatalError(Exception exception, Map<String, Object> parameters) {
        this.listeners.forEach(l -> l.onPrepareFatalError(exception, parameters));
    }

    @Override
    public void onPrepareEnd(Map<String, Object> parameters) {
        this.listeners.forEach(l -> l.onPrepareEnd(parameters));
    }

    @Override
    public void onSendMessageSuccess(ExtendedMimeMessage message, Map<String, Object> parameters) {
        this.listeners.forEach(l -> l.onSendMessageSuccess(message, parameters));
    }

    @Override
    public void onSendMessageError(ExtendedMimeMessage message, Exception exception, Map<String, Object> parameters) {
        this.listeners.forEach(l -> l.onSendMessageError(message, exception, parameters));
    }

    @Override
    public void onSendMessageFatalError(String uniqueMessageId, Exception exception, Map<String, Object> parameters) {
        this.listeners.forEach(l -> l.onSendMessageFatalError(uniqueMessageId, exception, parameters));
    }

    @Override
    public MailStatusResult getMailStatusResult() {
        return this.mainListener.getMailStatusResult();
    }
}

