/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.configuration;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.mail.MailSenderConfiguration;

@Component
@Singleton
public class DefaultMailSenderConfiguration
implements MailSenderConfiguration {
    public static final String JAVAMAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String JAVAMAIL_SMTP_HOST = "mail.smtp.host";
    public static final String JAVAMAIL_SMTP_PORT = "mail.smtp.port";
    public static final String JAVAMAIL_SMTP_USERNAME = "mail.smtp.user";
    public static final String JAVAMAIL_SMTP_FROM = "mail.smtp.from";
    public static final String JAVAMAIL_SMTP_AUTH = "mail.smtp.auth";
    private static final String PREFIX = "mail.sender.";
    private static final int DEFAULT_PORT = 25;
    private static final long DEFAULT_SEND_WAIT_TIME = 8000L;
    private static final String FROM_PROPERTY = "from";
    private static final String BCC_PROPERTY = "bcc";
    private static final String HOST_PROPERTY = "host";
    private static final String PORT_PROPERTY = "port";
    private static final String USERNAME_PROPERTY = "username";
    private static final String PASSWORD_PROPERTY = "password";
    private static final String PROPERTIES_PROPERTY = "properties";
    private static final String SEND_WAIT_TIME = "sendWaitTime";
    @Inject
    private Logger logger;
    @Inject
    @Named(value="mailsend")
    private ConfigurationSource mailConfigSource;
    @Inject
    @Named(value="documents")
    private ConfigurationSource documentsSource;
    @Inject
    @Named(value="xwikiproperties")
    private ConfigurationSource xwikiPropertiesSource;

    public String getHost() {
        String host = (String)this.mailConfigSource.getProperty(HOST_PROPERTY, this.documentsSource.getProperty("smtp_server", String.class));
        if (host == null) {
            host = (String)this.xwikiPropertiesSource.getProperty("mail.sender.host", (Object)"localhost");
        }
        return host;
    }

    public int getPort() {
        Integer port = null;
        String portAsString = (String)this.documentsSource.getProperty("smtp_port");
        if (!StringUtils.isEmpty((CharSequence)portAsString)) {
            try {
                port = (Integer)this.mailConfigSource.getProperty(PORT_PROPERTY, (Object)Integer.parseInt(portAsString));
            }
            catch (NumberFormatException e) {
                port = 25;
            }
        } else {
            port = (Integer)this.mailConfigSource.getProperty(PORT_PROPERTY, Integer.class);
        }
        if (port == null) {
            port = (Integer)this.xwikiPropertiesSource.getProperty("mail.sender.port", (Object)25);
        }
        return port;
    }

    public String getUsername() {
        String username = (String)this.mailConfigSource.getProperty(USERNAME_PROPERTY, this.documentsSource.getProperty("smtp_server_username", String.class));
        if (username == null) {
            username = (String)this.xwikiPropertiesSource.getProperty("mail.sender.username", String.class);
        }
        return username;
    }

    public String getPassword() {
        String password = (String)this.mailConfigSource.getProperty(PASSWORD_PROPERTY, this.documentsSource.getProperty("smtp_server_password", String.class));
        if (password == null) {
            password = (String)this.xwikiPropertiesSource.getProperty("mail.sender.password", String.class);
        }
        return password;
    }

    public List<String> getBCCAddresses() {
        ArrayList<String> bccAddresses = new ArrayList<String>();
        String bccAsString = (String)this.mailConfigSource.getProperty(BCC_PROPERTY, String.class);
        if (bccAsString == null) {
            bccAsString = (String)this.xwikiPropertiesSource.getProperty("mail.sender.bcc", String.class);
        }
        if (bccAsString != null) {
            for (String address : StringUtils.split((String)bccAsString, (char)',')) {
                bccAddresses.add(StringUtils.trim((String)address));
            }
        }
        return bccAddresses;
    }

    public String getFromAddress() {
        String from = (String)this.mailConfigSource.getProperty(FROM_PROPERTY, this.documentsSource.getProperty("admin_email", String.class));
        if (from == null) {
            from = (String)this.xwikiPropertiesSource.getProperty("mail.sender.from", String.class);
        }
        return from;
    }

    public Properties getAdditionalProperties() {
        Properties properties;
        String extraPropertiesAsString = (String)this.mailConfigSource.getProperty(PROPERTIES_PROPERTY, this.documentsSource.getProperty("javamail_extra_props", String.class));
        if (extraPropertiesAsString == null) {
            properties = (Properties)this.xwikiPropertiesSource.getProperty("mail.sender.properties", Properties.class);
        } else {
            ByteArrayInputStream is = new ByteArrayInputStream(extraPropertiesAsString.getBytes());
            properties = new Properties();
            try {
                properties.load(is);
            }
            catch (Exception e) {
                this.logger.warn("Error while parsing mail properties [{}]. Root cause [{}]. Ignoring configuration...", (Object)extraPropertiesAsString, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return properties;
    }

    public Properties getAllProperties() {
        Properties properties = new Properties();
        this.addProperty(properties, JAVAMAIL_TRANSPORT_PROTOCOL, "smtp");
        this.addProperty(properties, JAVAMAIL_SMTP_HOST, this.getHost());
        this.addProperty(properties, JAVAMAIL_SMTP_USERNAME, this.getUsername());
        this.addProperty(properties, JAVAMAIL_SMTP_FROM, this.getFromAddress());
        this.addProperty(properties, JAVAMAIL_SMTP_PORT, Integer.toString(this.getPort()));
        if (this.usesAuthentication()) {
            properties.put(JAVAMAIL_SMTP_AUTH, "true");
        }
        properties.putAll((Map<?, ?>)this.getAdditionalProperties());
        return properties;
    }

    private void addProperty(Properties properties, String key, String value) {
        if (value != null) {
            properties.setProperty(key, value);
        }
    }

    public boolean usesAuthentication() {
        return !StringUtils.isEmpty((CharSequence)this.getUsername()) && !StringUtils.isEmpty((CharSequence)this.getPassword());
    }

    public String getScriptServicePermissionCheckerHint() {
        return (String)this.xwikiPropertiesSource.getProperty("mail.sender.scriptServiceCheckerHint", (Object)"programmingrights");
    }

    public long getSendWaitTime() {
        Long waitTime = (Long)this.mailConfigSource.getProperty(SEND_WAIT_TIME);
        if (waitTime == null) {
            waitTime = (Long)this.xwikiPropertiesSource.getProperty("mail.sender.sendWaitTime", (Object)8000L);
        }
        return waitTime;
    }
}

