/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.template;

import java.util.Map;
import javax.inject.Inject;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MimeBodyPartFactory;
import org.xwiki.mail.internal.factory.AbstractMimeMessageFactory;
import org.xwiki.mail.internal.factory.template.MailTemplateManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.properties.ConverterManager;

public abstract class AbstractTemplateMimeMessageFactory
extends AbstractMimeMessageFactory<MimeMessage> {
    @Inject
    private ConverterManager converterManager;

    protected abstract MailTemplateManager getTemplateManager();

    protected abstract MimeBodyPartFactory<DocumentReference> getMimeBodyPartFactory();

    public MimeMessage createMessage(Object templateReferenceObject, Map<String, Object> parameters) throws MessagingException {
        DocumentReference templateReference = this.getTypedSource(templateReferenceObject, DocumentReference.class);
        ExtendedMimeMessage message = new ExtendedMimeMessage();
        Address from = (Address)this.converterManager.convert(Address.class, parameters.get("from"));
        if (from != null) {
            message.setFrom(from);
        }
        this.setRecipient((MimeMessage)message, Message.RecipientType.TO, parameters.get("to"));
        this.setRecipient((MimeMessage)message, Message.RecipientType.CC, parameters.get("cc"));
        this.setRecipient((MimeMessage)message, Message.RecipientType.BCC, parameters.get("bcc"));
        String type = (String)parameters.get("type");
        if (type != null) {
            message.setType(type);
        }
        Map velocityVariables = (Map)parameters.get("velocityVariables");
        Object localeValue = parameters.get("language");
        String subject = this.getTemplateManager().evaluate(templateReference, "subject", velocityVariables, localeValue);
        message.setSubject(subject);
        MimeMultipart multipart = new MimeMultipart("mixed");
        multipart.addBodyPart((BodyPart)this.getMimeBodyPartFactory().create((Object)templateReference, parameters));
        message.setContent((Multipart)multipart);
        return message;
    }

    private void setRecipient(MimeMessage message, Message.RecipientType type, Object value) throws MessagingException {
        Address[] addresses = (Address[])this.converterManager.convert(Address[].class, value);
        if (addresses != null) {
            message.setRecipients(type, addresses);
        }
    }
}

