/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.thread;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.xwiki.mail.internal.thread.MailQueueItem;
import org.xwiki.mail.internal.thread.MailQueueManager;

public abstract class AbstractMailQueueManager<T extends MailQueueItem>
implements MailQueueManager<T> {
    private Queue<T> mailQueue = new ConcurrentLinkedQueue<T>();

    private Queue<T> getMailQueue() {
        return this.mailQueue;
    }

    @Override
    public void addToQueue(T mailQueueItem) {
        this.getMailQueue().add(mailQueueItem);
    }

    @Override
    public boolean hasMessage() {
        return !this.getMailQueue().isEmpty();
    }

    @Override
    public T peekMessage() {
        return (T)((MailQueueItem)this.getMailQueue().peek());
    }

    @Override
    public boolean removeMessageFromQueue(T mailQueueItem) {
        return this.getMailQueue().remove(mailQueueItem);
    }
}

