/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.messagestream.internal;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.expression.EventProperty;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.expression.generics.AbstractValueNode;
import org.xwiki.notifications.filters.expression.generics.ExpressionBuilder;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceProperty;

@Component
@Singleton
@Named(value="DirectMessageStreamNotificationFilter")
public class DirectMessageStreamNotificationFilter
implements NotificationFilter {
    @Inject
    private EntityReferenceSerializer<String> serializer;

    public NotificationFilter.FilterPolicy filterEvent(Event event, DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        if (!"directMessage".equals(event.getType())) {
            return NotificationFilter.FilterPolicy.NO_EFFECT;
        }
        if (user != null) {
            String userId = (String)this.serializer.serialize((EntityReference)user, new Object[0]);
            return userId.equals(event.getStream()) ? NotificationFilter.FilterPolicy.NO_EFFECT : NotificationFilter.FilterPolicy.FILTER;
        }
        return NotificationFilter.FilterPolicy.FILTER;
    }

    public boolean matchesPreference(NotificationPreference preference) {
        return "directMessage".equals(this.getEventType(preference));
    }

    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationPreference preference) {
        if (user == null) {
            return null;
        }
        return ExpressionBuilder.value((EventProperty)EventProperty.STREAM).eq((AbstractValueNode)ExpressionBuilder.value((EntityReference)user));
    }

    private String getEventType(NotificationPreference preference) {
        return (String)preference.getProperties().get(NotificationPreferenceProperty.EVENT_TYPE);
    }

    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFilterType type, NotificationFormat format) {
        return null;
    }

    public String getName() {
        return "Direct Message Stream Notification Filter";
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

