/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.messagestream.internal;

import java.util.Collection;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.expression.ExpressionNode;
import org.xwiki.notifications.filters.internal.user.EventUserFilterPreferencesGetter;
import org.xwiki.notifications.preferences.NotificationPreference;
import org.xwiki.notifications.preferences.NotificationPreferenceProperty;

@Component
@Singleton
@Named(value="PersonalMessageStreamNotificationFilter")
public class PersonalMessageStreamNotificationFilter
implements NotificationFilter {
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private EventUserFilterPreferencesGetter preferencesGetter;

    public NotificationFilter.FilterPolicy filterEvent(Event event, DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFormat format) {
        if (!"personalMessage".equals(event.getType())) {
            return NotificationFilter.FilterPolicy.NO_EFFECT;
        }
        String sender = (String)this.serializer.serialize((EntityReference)event.getUser(), new Object[0]);
        return this.preferencesGetter.isUsedFollowed(sender, filterPreferences, format) ? NotificationFilter.FilterPolicy.KEEP : NotificationFilter.FilterPolicy.FILTER;
    }

    public boolean matchesPreference(NotificationPreference preference) {
        return "personalMessage".equals(this.getEventType(preference));
    }

    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationPreference preference) {
        return null;
    }

    private String getEventType(NotificationPreference preference) {
        return (String)preference.getProperties().get(NotificationPreferenceProperty.EVENT_TYPE);
    }

    public ExpressionNode filterExpression(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences, NotificationFilterType type, NotificationFormat format) {
        return null;
    }

    public String getName() {
        return "Personal Message Stream Notification Filter";
    }
}

