/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference.converter;

import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.EnumUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.namespace.NamespaceUtils;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.properties.ConverterManager;
import org.xwiki.properties.converter.AbstractConverter;
import org.xwiki.properties.converter.ConversionException;
import org.xwiki.properties.converter.Converter;

@Component
@Singleton
public class EntityReferenceConverter
extends AbstractConverter<EntityReference> {
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> stringResolver;
    @Inject
    private ConverterManager converterManager;
    @Inject
    private Logger logger;
    @Inject
    private EntityReferenceSerializer<String> serialier;

    protected EntityReference convertToType(Type type, Object value) {
        EntityReference result;
        if (value == null) {
            result = null;
        } else {
            Converter converter = this.converterManager.getConverter(value.getClass());
            if (converter != null) {
                try {
                    result = (EntityReference)converter.convert(EntityReference.class, value);
                }
                catch (ConversionException e) {
                    this.logger.warn("The type [{}] cannot be converted natively to EntityReference, falling back on using toString to convert it.", (Object)value.getClass().getName());
                    result = this.convertToType(type, value.toString());
                }
            } else {
                result = this.convertToType(type, value.toString());
            }
        }
        return result;
    }

    private EntityReference convertToType(Type type, String value) {
        Namespace namespace = NamespaceUtils.toNamespace((String)value);
        EntityType entityType = namespace.getType() != null ? (EntityType)EnumUtils.getEnum(EntityType.class, (String)namespace.getType().toUpperCase()) : null;
        String entityReference = namespace.getValue();
        if (entityType == null) {
            entityType = EntityType.DOCUMENT;
            entityReference = value;
        }
        return this.stringResolver.resolve(entityReference, entityType, new Object[0]);
    }

    protected String convertToString(EntityReference value) {
        if (value == null) {
            return null;
        }
        return new Namespace(value.getType().getLowerCase(), this.serialier.serialize(value, new Object[0])).toString();
    }
}

