/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.beans.Transient;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import javax.inject.Provider;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;

public class SpaceReference
extends EntityReference {
    public static final Type TYPE_PROVIDER = new DefaultParameterizedType(null, Provider.class, new Type[]{SpaceReference.class});

    public SpaceReference(EntityReference reference) {
        super(reference);
    }

    protected SpaceReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public SpaceReference(String spaceName, WikiReference parent) {
        this(spaceName, (EntityReference)parent);
    }

    public SpaceReference(String spaceName, SpaceReference parent) {
        this(spaceName, (EntityReference)parent);
    }

    public SpaceReference(String spaceName, EntityReference parent) {
        super(spaceName, EntityType.SPACE, parent);
    }

    public SpaceReference(String wikiName, String ... spaceNames) {
        this(wikiName, Arrays.asList(spaceNames));
    }

    public SpaceReference(String wikiName, List<String> spaceNames) {
        this(spaceNames.get(spaceNames.size() - 1), spaceNames.size() > 1 ? new SpaceReference(wikiName, spaceNames.subList(0, spaceNames.size() - 1)) : new WikiReference(wikiName));
    }

    public SpaceReference(EntityReference reference, EntityReference parent) {
        super(reference, parent);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent instanceof SpaceReference || parent instanceof WikiReference) {
            super.setParent(parent);
            return;
        }
        if (parent == null || parent.getType() != EntityType.SPACE && parent.getType() != EntityType.WIKI) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] in a space reference");
        }
        if (parent.getType() == EntityType.SPACE) {
            super.setParent(new SpaceReference(parent));
        } else {
            super.setParent(new WikiReference(parent));
        }
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.SPACE) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for a space reference");
        }
        super.setType(EntityType.SPACE);
    }

    @Override
    public SpaceReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        if (newParent == oldParent) {
            return this;
        }
        return new SpaceReference(this, oldParent, newParent);
    }

    @Override
    public SpaceReference replaceParent(EntityReference newParent) {
        if (newParent == this.getParent()) {
            return this;
        }
        return new SpaceReference((EntityReference)this, newParent);
    }

    @Transient
    public WikiReference getWikiReference() {
        return (WikiReference)this.extractReference(EntityType.WIKI);
    }
}

