/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.validation.internal;

import java.util.Collections;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.model.validation.EntityNameValidation;
import org.xwiki.model.validation.EntityNameValidationConfiguration;
import org.xwiki.model.validation.EntityNameValidationManager;
import org.xwiki.model.validation.internal.ReplaceCharacterEntityNameValidation;
import org.xwiki.model.validation.internal.ReplaceCharacterEntityNameValidationConfiguration;

@Component
@Singleton
public class DefaultEntityNameValidationManager
implements EntityNameValidationManager {
    @Inject
    private ComponentManager componentManager;
    @Inject
    private EntityNameValidationConfiguration entityNameValidationConfiguration;
    @Inject
    private ReplaceCharacterEntityNameValidationConfiguration replaceCharacterEntityNameValidationConfiguration;
    @Inject
    private Logger logger;
    @Inject
    @Named(value="ReplaceCharacterEntityNameValidation")
    private EntityNameValidation replaceCharacterValidator;

    public EntityNameValidation getEntityReferenceNameStrategy() {
        return this.getEntityReferenceNameStrategy(this.entityNameValidationConfiguration.getEntityNameValidation());
    }

    public EntityNameValidation getEntityReferenceNameStrategy(String hint) {
        try {
            return (EntityNameValidation)this.componentManager.getInstance(EntityNameValidation.class, hint);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Error while getting the EntityReferenceNameStrategy with hint [{}]", (Object)hint, (Object)e);
            return null;
        }
    }

    public Set<String> getAvailableEntityNameValidations() {
        try {
            return this.componentManager.getInstanceMap(EntityNameValidation.class).keySet();
        }
        catch (ComponentLookupException e) {
            this.logger.error("Error while getting the instance map of the EntityNameValidation", (Throwable)e);
            return Collections.emptySet();
        }
    }

    public void resetStrategies() {
        ((ReplaceCharacterEntityNameValidation)this.replaceCharacterValidator).setReplacementCharacters(this.replaceCharacterEntityNameValidationConfiguration.getCharacterReplacementMap());
    }
}

