/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.io.Serializable;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.AbstractStringEntityReferenceSerializer;
import org.xwiki.model.internal.reference.SymbolScheme;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.text.StringUtils;

@Component
@Singleton
public class DefaultStringEntityReferenceSerializer
extends AbstractStringEntityReferenceSerializer {
    @Inject
    private SymbolScheme symbolScheme;

    public DefaultStringEntityReferenceSerializer() {
    }

    public DefaultStringEntityReferenceSerializer(SymbolScheme symbolScheme) {
        this.symbolScheme = symbolScheme;
    }

    @Override
    protected void serializeEntityReference(EntityReference currentReference, StringBuilder representation, boolean isLastReference, Object ... parameters) {
        Character parameterSeparator;
        EntityType currentType = currentReference.getType();
        EntityReference parentReference = currentReference.getParent();
        if (parentReference != null && representation.length() > 0) {
            Character separator = this.getSymbolScheme().getSeparatorSymbols().get((Object)currentType).get((Object)parentReference.getType());
            if (separator != null) {
                representation.append(separator);
            } else {
                representation.append("???");
            }
        }
        representation.append(StringUtils.replaceEach((String)currentReference.getName(), (String[])this.getSymbolScheme().getSymbolsRequiringEscapes(currentType), (String[])this.getSymbolScheme().getReplacementSymbols(currentType)));
        Map<String, Serializable> entityParameters = currentReference.getParameters();
        if (!entityParameters.isEmpty() && (parameterSeparator = this.getSymbolScheme().getParameterSeparator(currentType)) != null) {
            representation.append(parameterSeparator);
            this.serializeParameters(this.getSymbolScheme().getDefaultParameter(currentType), parameterSeparator.charValue(), entityParameters, representation, this.getSymbolScheme().getParameterSymbolsRequiringEscapes(currentType), this.getSymbolScheme().getParameterReplacementSymbols(currentType));
        }
    }

    private void serializeParameters(String defaultParameter, char separator, Map<String, Serializable> parameters, StringBuilder representation, String[] parameterSymbolsRequiringEscapes, String[] parameterReplacementSymbols) {
        boolean first = true;
        for (Map.Entry<String, Serializable> entry : parameters.entrySet()) {
            if (entry.getValue() == null) continue;
            if (!first) {
                representation.append(separator);
            }
            if (defaultParameter == null || !defaultParameter.equals(entry.getKey())) {
                representation.append(StringUtils.replaceEach((String)entry.getKey(), (String[])parameterSymbolsRequiringEscapes, (String[])parameterReplacementSymbols));
                representation.append('=');
            }
            representation.append(StringUtils.replaceEach((String)entry.getValue().toString(), (String[])parameterSymbolsRequiringEscapes, (String[])parameterReplacementSymbols));
            first = false;
        }
    }

    protected SymbolScheme getSymbolScheme() {
        return this.symbolScheme;
    }
}

