/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.SymbolScheme;

@Component
@Singleton
public class DefaultSymbolScheme
implements SymbolScheme {
    private static final char CESCAPE = '\\';
    private static final char CWIKISEP = ':';
    private static final char CSPACESEP = '.';
    private static final char CATTACHMENTSEP = '@';
    private static final char COBJECTSEP = '^';
    private static final char CPROPERTYSEP = '.';
    private static final char CCLASSPROPSEP = '^';
    private static final Map<EntityType, Map<EntityType, Character>> SEPARATORS = new HashMap<EntityType, Map<EntityType, Character>>(){
        {
            this.put(EntityType.WIKI, Collections.emptyMap());
            HashMap<EntityType, Character> spaceSeparators = new HashMap<EntityType, Character>();
            spaceSeparators.put(EntityType.WIKI, Character.valueOf(':'));
            spaceSeparators.put(EntityType.SPACE, Character.valueOf('.'));
            this.put(EntityType.SPACE, spaceSeparators);
            this.put(EntityType.DOCUMENT, Collections.singletonMap(EntityType.SPACE, Character.valueOf('.')));
            this.put(EntityType.ATTACHMENT, Collections.singletonMap(EntityType.DOCUMENT, Character.valueOf('@')));
            this.put(EntityType.OBJECT, Collections.singletonMap(EntityType.DOCUMENT, Character.valueOf('^')));
            this.put(EntityType.OBJECT_PROPERTY, Collections.singletonMap(EntityType.OBJECT, Character.valueOf('.')));
            this.put(EntityType.CLASS_PROPERTY, Collections.singletonMap(EntityType.DOCUMENT, Character.valueOf('^')));
        }
    };
    private Map<EntityType, String[]> escapes;
    private Map<EntityType, String[]> replacements;

    public DefaultSymbolScheme() {
        this.initialize();
    }

    public void initialize() {
        this.escapes = new HashMap<EntityType, String[]>();
        this.replacements = new HashMap<EntityType, String[]>();
        String escape = Character.toString(this.getEscapeSymbol().charValue());
        for (Map.Entry<EntityType, Map<EntityType, Character>> entry : SEPARATORS.entrySet()) {
            EntityType type = entry.getKey();
            Map<EntityType, Character> separators = entry.getValue();
            ArrayList<String> charactersToEscape = new ArrayList<String>();
            ArrayList<String> replacementCharacters = new ArrayList<String>();
            for (Character characterToEscape : separators.values()) {
                charactersToEscape.add(Character.toString(characterToEscape.charValue()));
                replacementCharacters.add(escape + Character.toString(characterToEscape.charValue()));
            }
            charactersToEscape.add(escape);
            replacementCharacters.add(escape + escape);
            String[] escapesArray = new String[charactersToEscape.size()];
            this.escapes.put(type, charactersToEscape.toArray(escapesArray));
            String[] replacementsArray = new String[replacementCharacters.size()];
            this.replacements.put(type, replacementCharacters.toArray(replacementsArray));
        }
    }

    @Override
    public Character getEscapeSymbol() {
        return Character.valueOf('\\');
    }

    @Override
    public Map<EntityType, Map<EntityType, Character>> getSeparatorSymbols() {
        return SEPARATORS;
    }

    @Override
    public String[] getSymbolsRequiringEscapes(EntityType type) {
        return this.escapes.get((Object)type);
    }

    @Override
    public String[] getReplacementSymbols(EntityType type) {
        return this.replacements.get((Object)type);
    }
}

