/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.ObjectReference;
import org.xwiki.model.reference.PageObjectReference;
import org.xwiki.stability.Unstable;

@Unstable
public class PageObjectPropertyReference
extends EntityReference {
    public PageObjectPropertyReference(EntityReference reference) {
        super(reference);
    }

    protected PageObjectPropertyReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public PageObjectPropertyReference(String propertyName, PageObjectReference objectReference) {
        super(propertyName, EntityType.PAGE_OBJECT_PROPERTY, (EntityReference)objectReference);
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.PAGE_OBJECT_PROPERTY) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for an object property reference");
        }
        super.setType(type);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent instanceof ObjectReference) {
            super.setParent(parent);
            return;
        }
        if (parent == null || parent.getType() != EntityType.PAGE_OBJECT) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] in an object property reference");
        }
        super.setParent(new PageObjectReference(parent));
    }

    @Override
    public PageObjectPropertyReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        return new PageObjectPropertyReference(this, oldParent, newParent);
    }
}

