/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.beans.Transient;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Provider;
import org.xwiki.component.util.DefaultParameterizedType;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.AbstractLocalizedEntityReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalPageReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.stability.Unstable;

@Unstable
public class PageReference
extends AbstractLocalizedEntityReference {
    public static final Type TYPE_PROVIDER = new DefaultParameterizedType(null, Provider.class, new Type[]{PageReference.class});

    public PageReference(EntityReference reference) {
        super(reference);
    }

    protected PageReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public PageReference(String pageName, WikiReference parent) {
        this(pageName, (EntityReference)parent);
    }

    public PageReference(String pageName, PageReference parent) {
        this(pageName, (EntityReference)parent);
    }

    public PageReference(String pageName, EntityReference parent) {
        super(pageName, EntityType.PAGE, parent);
    }

    public PageReference(String pageName, EntityReference parent, Locale locale) {
        super(pageName, EntityType.PAGE, parent, locale);
    }

    public PageReference(EntityReference reference, Locale locale) {
        super(reference, locale);
    }

    public PageReference(String wikiName, List<String> pageNames) {
        this(pageNames.get(pageNames.size() - 1), pageNames.size() > 1 ? new PageReference(wikiName, pageNames.subList(0, pageNames.size() - 1)) : new WikiReference(wikiName));
    }

    public PageReference(String wikiName, List<String> pageNames, Locale locale) {
        this(pageNames.get(pageNames.size() - 1), pageNames.size() > 1 ? new PageReference(wikiName, pageNames.subList(0, pageNames.size() - 1)) : new WikiReference(wikiName), locale);
    }

    public PageReference(String wikiName, String pageName, String ... pageNames) {
        this(wikiName, PageReference.toList(pageName, pageNames));
    }

    public PageReference(LocalPageReference localPageReference, WikiReference wikiReference) {
        super(localPageReference, null, (EntityReference)wikiReference);
    }

    static List<String> toList(String inputPageName, String ... inputPageNames) {
        ArrayList<String> pageNames = new ArrayList<String>(inputPageNames.length + 1);
        pageNames.add(inputPageName);
        for (String pageName : inputPageNames) {
            pageNames.add(pageName);
        }
        return pageNames;
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent instanceof PageReference || parent instanceof WikiReference) {
            super.setParent(parent);
            return;
        }
        if (parent == null || parent.getType() != EntityType.PAGE && parent.getType() != EntityType.WIKI) {
            throw new IllegalArgumentException("Invalid parent reference [" + parent + "] in a page reference");
        }
        if (parent.getType() == EntityType.PAGE) {
            super.setParent(new PageReference(parent));
        } else {
            super.setParent(new WikiReference(parent));
        }
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.PAGE) {
            throw new IllegalArgumentException("Invalid type [" + (Object)((Object)type) + "] for a page reference");
        }
        super.setType(type);
    }

    @Override
    public PageReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        return new PageReference(this, oldParent, newParent);
    }

    @Transient
    public WikiReference getWikiReference() {
        return (WikiReference)this.extractReference(EntityType.WIKI);
    }

    @Override
    public String toString() {
        return TOSTRING_SERIALIZER.serialize(this, new Object[0]);
    }
}

