/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.internal.reference.AbstractStringEntityReferenceSerializer;
import org.xwiki.model.reference.EntityReference;

@Component
@Named(value="path")
@Singleton
public class PathStringEntityReferenceSerializer
extends AbstractStringEntityReferenceSerializer {
    @Override
    protected void serializeEntityReference(EntityReference currentReference, StringBuilder representation, boolean isLastReference, Object ... parameters) {
        if (currentReference.getParent() != null) {
            representation.append('/');
        }
        representation.append(this.encodeReferenceName(currentReference.getName(), isLastReference));
    }

    protected String encodeReferenceName(String name, boolean isLastReference) {
        try {
            String encodedName = URLEncoder.encode(name, "UTF-8");
            encodedName = this.replaceDot(encodedName, isLastReference);
            encodedName = this.replaceStar(encodedName, isLastReference);
            return encodedName;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not present on the system!", e);
        }
    }

    protected String replaceDot(String name, boolean isLastReference) {
        return name.replace(".", "%2E");
    }

    protected String replaceStar(String name, boolean isLastReference) {
        return name.replace("*", "%2A");
    }
}

